"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultRowsPerPage = exports.VIEW_MODE = exports.TRACES_PRODUCT_FEATURE_ID = exports.TAB_STATE_URL_KEY = exports.ROWS_PER_PAGE_OPTIONS = exports.NEW_TAB_ID = exports.METRICS_EXPERIENCE_PRODUCT_FEATURE_ID = exports.GLOBAL_STATE_URL_KEY = exports.ESQL_TRANSITION_MODAL_KEY = exports.DEFAULT_ROWS_PER_PAGE = exports.APP_STATE_URL_KEY = void 0;
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_ROWS_PER_PAGE = exports.DEFAULT_ROWS_PER_PAGE = 100;
const ROWS_PER_PAGE_OPTIONS = exports.ROWS_PER_PAGE_OPTIONS = [10, 25, 50, DEFAULT_ROWS_PER_PAGE, 250, 500];
let VIEW_MODE = exports.VIEW_MODE = /*#__PURE__*/function (VIEW_MODE) {
  VIEW_MODE["DOCUMENT_LEVEL"] = "documents";
  VIEW_MODE["AGGREGATED_LEVEL"] = "aggregated";
  VIEW_MODE["PATTERN_LEVEL"] = "patterns";
  return VIEW_MODE;
}({});
const getDefaultRowsPerPage = uiSettings => {
  return parseInt(uiSettings.get(_discoverUtils.SAMPLE_ROWS_PER_PAGE_SETTING), 10) || DEFAULT_ROWS_PER_PAGE;
};

// local storage key for the ES|QL to Dataviews transition modal
exports.getDefaultRowsPerPage = getDefaultRowsPerPage;
const ESQL_TRANSITION_MODAL_KEY = exports.ESQL_TRANSITION_MODAL_KEY = 'data.textLangTransitionModal';

/**
 * The id value used to indicate that a link should open in a new Discover tab.
 * It will be used in the `_tab` URL param to indicate that a new tab should be created.
 * Once created, the new tab will have a unique id.
 */
const NEW_TAB_ID = exports.NEW_TAB_ID = 'new';

/**
 * The query param key used to store the Discover app state in the URL
 */
const APP_STATE_URL_KEY = exports.APP_STATE_URL_KEY = '_a';
const GLOBAL_STATE_URL_KEY = exports.GLOBAL_STATE_URL_KEY = '_g';
const TAB_STATE_URL_KEY = exports.TAB_STATE_URL_KEY = '_tab'; // `_t` is already used by Kibana for time, so we use `_tab` here

/**
 * Product feature IDs
 */
const TRACES_PRODUCT_FEATURE_ID = exports.TRACES_PRODUCT_FEATURE_ID = 'discover:traces';
const METRICS_EXPERIENCE_PRODUCT_FEATURE_ID = exports.METRICS_EXPERIENCE_PRODUCT_FEATURE_ID = 'discover:metrics-experience';