"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedDocsDetails = getFailedDocsDetails;
var _constants = require("../../../../common/constants");
var _es_fields = require("../../../../common/es_fields");
var _utils = require("../../../utils");
var _get_interval = require("../../../utils/get_interval");
var _queries = require("../../../utils/queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getFailedDocsDetails({
  esClient,
  start,
  end,
  dataStream
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const fieldInterval = (0, _get_interval.getFieldIntervalInSeconds)({
    start,
    end
  });
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const filterQuery = [...(0, _queries.rangeQuery)(start, end)];
  const aggs = {
    lastOccurrence: {
      max: {
        field: _es_fields.TIMESTAMP
      }
    },
    timeSeries: {
      date_histogram: {
        field: _es_fields.TIMESTAMP,
        fixed_interval: `${fieldInterval}s`,
        min_doc_count: 0,
        extended_bounds: {
          min: start,
          max: end
        }
      }
    }
  };
  const response = await datasetQualityESClient.search({
    index: `${dataStream}${_constants.FAILURE_STORE_SELECTOR}`,
    track_total_hits: true,
    size: 0,
    query: {
      bool: {
        filter: filterQuery
      }
    },
    aggs
  });
  return {
    count: response.hits.total.value,
    lastOccurrence: (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.lastOccurrence.value,
    timeSeries: (_response$aggregation2 = (_response$aggregation3 = response.aggregations) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.timeSeries.buckets.map(timeSeriesBucket => ({
      x: timeSeriesBucket.key,
      y: timeSeriesBucket.doc_count
    }))) !== null && _response$aggregation2 !== void 0 ? _response$aggregation2 : []
  };
}