"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isActiveDataset = exports.filterInactiveDatasets = void 0;
var _timerange = require("@kbn/timerange");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterInactiveDatasets = ({
  datasets,
  timeRange = _constants.DEFAULT_TIME_RANGE
}) => {
  const {
    startDate,
    endDate
  } = (0, _timerange.getDateRange)(timeRange);
  return datasets.filter(dataset => dataset.lastActivity ? isActive(dataset.lastActivity, startDate, endDate) : false);
};
exports.filterInactiveDatasets = filterInactiveDatasets;
const isActiveDataset = options => {
  const {
    lastActivity,
    timeRange
  } = options;
  const {
    startDate,
    endDate
  } = (0, _timerange.getDateRange)(timeRange);
  return isActive(lastActivity, startDate, endDate);
};
exports.isActiveDataset = isActiveDataset;
const isActive = (lastActivity, startDate, endDate) => lastActivity >= startDate && lastActivity <= endDate;