"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _telemetry = require("./services/telemetry");
var _dataset_quality = require("./components/dataset_quality");
var _dataset_quality_details = require("./components/dataset_quality_details");
var _lazy_create_controller = require("./controller/dataset_quality/lazy_create_controller");
var _lazy_create_controller2 = require("./controller/dataset_quality_details/lazy_create_controller");
var _rule_types = require("./rule_types");
var _data_stream_details = require("./services/data_stream_details");
var _data_streams_stats = require("./services/data_streams_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DatasetQualityPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "telemetry", new _telemetry.TelemetryService());
  }
  setup(core, plugins) {
    this.telemetry.setup({
      analytics: core.analytics
    });
    (0, _rule_types.registerRuleTypes)({
      ruleTypeRegistry: plugins.triggersActionsUi.ruleTypeRegistry
    });
    return {};
  }
  start(core, plugins) {
    const telemetryClient = this.telemetry.start();
    const dataStreamStatsService = new _data_streams_stats.DataStreamsStatsService().start({
      http: core.http
    });
    const dataStreamDetailsService = new _data_stream_details.DataStreamDetailsService().start({
      http: core.http,
      telemetryClient
    });
    const DatasetQuality = (0, _dataset_quality.createDatasetQuality)({
      core,
      plugins,
      telemetryClient
    });
    const createDatasetQualityController = (0, _lazy_create_controller.createDatasetQualityControllerLazyFactory)({
      core,
      dataStreamStatsService
    });
    const DatasetQualityDetails = (0, _dataset_quality_details.createDatasetQualityDetails)({
      core,
      plugins,
      telemetryClient
    });
    const createDatasetQualityDetailsController = (0, _lazy_create_controller2.createDatasetQualityDetailsControllerLazyFactory)({
      core,
      plugins,
      dataStreamStatsService,
      dataStreamDetailsService
    });
    return {
      DatasetQuality,
      createDatasetQualityController,
      DatasetQualityDetails,
      createDatasetQualityDetailsController
    };
  }
}
exports.DatasetQualityPlugin = DatasetQualityPlugin;