"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = QualityIssueFlyout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _es_fields = require("../../../../common/es_fields");
var _translations = require("../../../../common/translations");
var _hooks = require("../../../hooks");
var _telemetry = require("../../../services/telemetry");
var _degraded_field = _interopRequireDefault(require("./degraded_field"));
var _failed_docs = _interopRequireDefault(require("./failed_docs"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function QualityIssueFlyout() {
  const {
    closeDegradedFieldFlyout,
    expandedDegradedField,
    renderedItems,
    isAnalysisInProgress,
    degradedFieldAnalysisFormattedResult
  } = (0, _hooks.useQualityIssues)();
  const {
    dataStreamSettings,
    datasetDetails,
    timeRange
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const pushedFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'pushedFlyoutTitle'
  });
  const fieldList = (0, _react.useMemo)(() => {
    return renderedItems.find(item => {
      return item.name === (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.name) && item.type === (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type);
    });
  }, [renderedItems, expandedDegradedField]);
  const isUserViewingTheIssueOnLatestBackingIndex = (dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : dataStreamSettings.lastBackingIndexName) === (fieldList === null || fieldList === void 0 ? void 0 : fieldList.indexFieldWasLastPresentIn);
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetDetailsRedirectLinkTelemetry)({
    query: {
      language: 'kuery',
      query: `${_es_fields._IGNORED}: ${expandedDegradedField}`
    },
    navigationSource: _telemetry.NavigationSource.DegradedFieldFlyoutHeader
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat: datasetDetails.rawName,
    timeRangeConfig: timeRange,
    query: {
      language: 'kuery',
      query: expandedDegradedField && expandedDegradedField.type === 'degraded' ? `${_es_fields._IGNORED}: ${expandedDegradedField.name}` : ''
    },
    selector: expandedDegradedField && expandedDegradedField.type === 'failed' ? _constants.FAILURE_STORE_SELECTOR : undefined,
    sendTelemetry
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: "push",
    size: "s",
    onClose: closeDegradedFieldFlyout,
    "aria-labelledby": pushedFlyoutTitleId,
    "data-test-subj": 'datasetQualityDetailsDegradedFieldFlyout',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'degraded' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.name, " ", _translations.fieldIgnoredText) : /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontWeight: 400
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.datasetQuality.datasetQualityDetails.qualityIssueFlyout.failedDocsTitle', {
    defaultMessage: 'Documents indexing failed'
  }))))), (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'degraded' && !isUserViewingTheIssueOnLatestBackingIndex && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutIssueDoesNotExist",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, _translations.degradedFieldMessageIssueDoesNotExistInLatestIndex)), (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'degraded' && isUserViewingTheIssueOnLatestBackingIndex && !isAnalysisInProgress && degradedFieldAnalysisFormattedResult && !degradedFieldAnalysisFormattedResult.identifiedUsingHeuristics && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutIssueDoesNotExist",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.details.degradedField.potentialCause.ignoreMalformedWarning",
    defaultMessage: "If you've recently updated your {field_limit} settings, this quality issue may not be relevant. Rollover the data stream to verify.",
    values: {
      field_limit: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.datasetQuality.degradedFieldFlyout.strong.fieldLimitLabel', {
        defaultMessage: 'field limit'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'degraded' && /*#__PURE__*/_react.default.createElement(_degraded_field.default, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 56
    }
  }), (expandedDegradedField === null || expandedDegradedField === void 0 ? void 0 : expandedDegradedField.type) === 'failed' && /*#__PURE__*/_react.default.createElement(_failed_docs.default, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 54
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeDegradedFieldFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, _translations.flyoutCancelText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "aria-label": _translations.discoverAriaText,
    size: "s",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutTitleLinkToDiscover"
  }, redirectLinkProps.linkProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }), _translations.openInDiscoverText)))));
}
module.exports = exports.default;