"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetSummary = DatasetSummary;
var _react = _interopRequireWildcard(require("react"));
var _fieldTypes = require("@kbn/field-types");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _integration_actions_menu = require("./integration_actions_menu");
var _translations = require("../../../../common/translations");
var _fields_list = require("./fields_list");
var _hooks = require("../../../hooks");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/details/dataset_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DatasetSummary() {
  var _integrationDetails$i, _integrationDetails$i2, _integrationDetails$i3;
  const {
    fieldFormats,
    dataStreamSettings,
    dataStreamDetails,
    loadingState,
    integrationDetails
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const dataFormatter = fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]);
  const {
    dataStreamDetailsLoading,
    dataStreamSettingsLoading,
    integrationDetailsLoading,
    integrationDetailsLoaded,
    integrationDashboardsLoading
  } = loadingState;
  const formattedLastActivity = dataStreamDetails !== null && dataStreamDetails !== void 0 && dataStreamDetails.lastActivity ? dataFormatter.convert(dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.lastActivity) : '-';
  const formattedCreatedOn = dataStreamSettings !== null && dataStreamSettings !== void 0 && dataStreamSettings.createdOn ? dataFormatter.convert(dataStreamSettings.createdOn) : '-';
  return !integrationDetailsLoaded ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "100%",
    height: "200px",
    "data-test-subj": "datasetQualityDetailsDetailsSectionLoading",
    className: "datasetQualityDetailsDetailsSectionLoading",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_fields_list.FieldsList, {
    fields: [...(integrationDetails !== null && integrationDetails !== void 0 && (_integrationDetails$i = integrationDetails.integration) !== null && _integrationDetails$i !== void 0 && _integrationDetails$i.integration ? [{
      fieldTitle: _translations.integrationNameText,
      fieldValue: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        css: (0, _react2.css)`
                          width: fit-content;
                        `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_common.IntegrationIcon, {
        integration: integrationDetails.integration.integration,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 27
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 27
        }
      }, (_integrationDetails$i2 = integrationDetails.integration.integration) === null || _integrationDetails$i2 === void 0 ? void 0 : _integrationDetails$i2.name))),
      actionsMenu: /*#__PURE__*/_react.default.createElement(_integration_actions_menu.IntegrationActionsMenu, {
        integration: integrationDetails.integration.integration,
        dashboards: integrationDetails.dashboard,
        dashboardsLoading: integrationDashboardsLoading,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 23
        }
      }),
      isLoading: integrationDetailsLoading
    }, {
      fieldTitle: _translations.integrationVersionText,
      fieldValue: (_integrationDetails$i3 = integrationDetails.integration.integration) === null || _integrationDetails$i3 === void 0 ? void 0 : _integrationDetails$i3.version,
      isLoading: integrationDetailsLoading
    }] : []), {
      fieldTitle: _translations.datasetLastActivityText,
      fieldValue: formattedLastActivity,
      isLoading: dataStreamDetailsLoading
    }, {
      fieldTitle: _translations.datasetCreatedOnText,
      fieldValue: formattedCreatedOn,
      isLoading: dataStreamSettingsLoading
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })));
}