"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternTableWithRouter = exports.IndexPatternTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPromptNoDataViews = require("@kbn/shared-ux-prompt-no-data-views");
var _public2 = require("@kbn/data-views-plugin/public");
var _rollup = require("@kbn/rollup");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _breadcrumbs = require("../breadcrumbs");
var _data_view_table_controller = require("./data_view_table_controller");
var _no_data = require("./no_data");
var _spaces_list = require("./spaces_list");
var _constants = require("../../constants");
var _delete_data_view_flyout = require("../delete_data_view_flyout/delete_data_view_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/data_view_management/public/components/index_pattern_table/index_pattern_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE_OPTIONS = [5, 10, 25, 50];
const sorting = {
  sort: {
    field: 'title',
    direction: 'asc'
  }
};
const securityDataView = _i18n.i18n.translate('indexPatternManagement.indexPatternTable.badge.securityDataViewTitle', {
  defaultMessage: 'Security Solution'
});
const securitySolution = 'security-solution';
const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const IndexPatternTable = ({
  history,
  canSave,
  setShowCreateDialog,
  title
}) => {
  const {
    setBreadcrumbs,
    http,
    uiSettings,
    application,
    chrome,
    dataViews,
    share,
    spaces,
    docLinks,
    noDataPage,
    savedObjectsManagement
  } = (0, _public.useKibana)().services;
  const [query, setQuery] = (0, _react.useState)('');
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const [selectedDataView, setSelectedDataView] = (0, _react.useState)();
  const [selectedRelationships, setSelectedRelationships] = (0, _react.useState)({});
  const [flyoutOpen, setFlyoutOpen] = _react.default.useState(false);
  const [dataViewController] = (0, _react.useState)(() => new _data_view_table_controller.DataViewTableController({
    services: {
      dataViews
    },
    config: {
      defaultDataView: uiSettings.get('defaultIndex')
    }
  }));
  const isLoadingIndexPatterns = (0, _useObservable.default)(dataViewController.isLoadingIndexPatterns$, _data_view_table_controller.dataViewTableControllerStateDefaults.isLoadingDataViews);
  const indexPatterns = (0, _useObservable.default)(dataViewController.indexPatterns$, _data_view_table_controller.dataViewTableControllerStateDefaults.dataViews);
  const isLoadingDataState = (0, _useObservable.default)(dataViewController.isLoadingDataState$, _data_view_table_controller.dataViewTableControllerStateDefaults.isLoadingHasData);
  const hasDataView = (0, _useObservable.default)(dataViewController.hasDataView$, _data_view_table_controller.dataViewTableControllerStateDefaults.hasDataView);
  const hasESData = (0, _useObservable.default)(dataViewController.hasESData$, _data_view_table_controller.dataViewTableControllerStateDefaults.hasEsData);
  const useOnTryESQLParams = {
    locatorClient: share === null || share === void 0 ? void 0 : share.url.locators,
    navigateToApp: application.navigateToApp
  };
  const onTryESQL = (0, _sharedUxPromptNoDataViews.useOnTryESQL)(useOnTryESQLParams);
  const {
    pageSize,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'dataViewsIndexPattern',
    initialPageSize: 10,
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const handleOnChange = ({
    queryText,
    error
  }) => {
    if (!error) {
      setQuery(queryText);
    }
  };
  const onFlyoutClose = () => {
    setFlyoutOpen(false);
    setSelectedItems([]);
    setSelectedDataView(undefined);
    setSelectedRelationships({});
  };
  const dataViewArray = (0, _react.useMemo)(() => {
    return selectedDataView ? [selectedDataView] : selectedItems;
  }, [selectedDataView, selectedItems]);
  const getRelationshipsForSelections = async selectedViews => {
    const allowedTypes = (await savedObjectsManagement.getAllowedTypes()).map(type => type.name);
    const relationships = {};
    const relationshipsArray = await Promise.all(selectedViews.map(async view => ({
      id: view.id,
      relations: await (await savedObjectsManagement.getRelationships(_public2.DATA_VIEW_SAVED_OBJECT_TYPE, view.id, allowedTypes, _constants.MAX_DISPLAYED_RELATIONSHIPS)).relations
    })));

    // Reduce the array to a relationships object keyed by id
    relationshipsArray.forEach(({
      id,
      relations
    }) => {
      relationships[id] = relations;
    });
    return relationships;
  };
  const renderDeleteButton = () => {
    if (selectedItems.length === 0) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      iconType: "trash",
      "data-test-subj": "delete-data-views-button",
      onClick: async () => {
        const relationships = (await getRelationshipsForSelections(selectedItems)) || {};
        setSelectedRelationships(relationships);
        setFlyoutOpen(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.dataViewTable.deleteButtonLabel",
      defaultMessage: "Delete {selectedItems, number} {selectedItems, plural, one {Data View} other {Data Views}\n}",
      values: {
        selectedItems: selectedItems.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 9
      }
    }));
  };
  const deleteButton = renderDeleteButton();
  const search = {
    toolsLeft: deleteButton && [deleteButton],
    query,
    onChange: handleOnChange,
    box: {
      incremental: true,
      schema: {
        fields: {
          title: {
            type: 'string'
          }
        }
      }
    }
  };
  setBreadcrumbs((0, _breadcrumbs.getListBreadcrumbs)());
  chrome.docTitle.change(title);
  const ContextWrapper = (0, _react.useMemo)(() => spaces ? spaces.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spaces]);
  const alertColumn = {
    name: 'Actions',
    field: 'id',
    width: '10%',
    actions: [{
      name: _i18n.i18n.translate('indexPatternManagement.dataViewTable.columnDelete', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.dataViewTable.columnDeleteDescription', {
        defaultMessage: 'Delete this data view'
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: async dataView => {
        const relationships = await getRelationshipsForSelections([dataView]);
        setSelectedDataView(dataView);
        setSelectedRelationships(relationships);
        setFlyoutOpen(true);
      },
      isPrimary: true,
      'data-test-subj': 'action-delete'
    }]
  };
  const columns = [{
    field: 'title',
    name: _i18n.i18n.translate('indexPatternManagement.dataViewTable.nameColumn', {
      defaultMessage: 'Name'
    }),
    width: spaces ? '70%' : '90%',
    render: (_name, dataView) => {
      var _dataView$id, _dataView$tags;
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 269,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, `patterns/${dataView.id}`), {
        "data-test-subj": `detail-link-${dataView.getName()}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 270,
          columnNumber: 11
        }
      }), dataView.getName(), dataView.name ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "info",
        color: "text",
        "aria-label": dataView.title,
        content: dataView.title,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 278,
          columnNumber: 17
        }
      })) : null), (dataView === null || dataView === void 0 ? void 0 : (_dataView$id = dataView.id) === null || _dataView$id === void 0 ? void 0 : _dataView$id.indexOf(securitySolution)) === 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\u2003", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "accent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 289,
          columnNumber: 21
        }
      }, securityDataView)), dataView === null || dataView === void 0 ? void 0 : (_dataView$tags = dataView.tags) === null || _dataView$tags === void 0 ? void 0 : _dataView$tags.map(({
        key: tagKey,
        name: tagName
      }) => /*#__PURE__*/_react.default.createElement("span", {
        key: tagKey,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 13
        }
      }, "\u2003", tagKey === _public2.DataViewType.ROLLUP ? /*#__PURE__*/_react.default.createElement(_rollup.RollupDeprecationTooltip, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 297,
          columnNumber: 19
        }
      }, tagName)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 17
        }
      }, tagName))));
    },
    dataType: 'string',
    sortable: ({
      sort
    }) => sort
  }];
  if (spaces) {
    columns.push({
      field: 'namespaces',
      name: _i18n.i18n.translate('indexPatternManagement.dataViewTable.spacesColumn', {
        defaultMessage: 'Spaces'
      }),
      width: '20%',
      render: (_name, dataView) => {
        return spaces ? /*#__PURE__*/_react.default.createElement(_spaces_list.SpacesList, {
          spacesApi: spaces,
          capabilities: application === null || application === void 0 ? void 0 : application.capabilities,
          spaceIds: dataView.namespaces || [],
          id: dataView.id,
          title: dataView.title,
          refresh: () => {
            dataViews.clearInstanceCache(dataView.id);
            dataViewController.loadDataViews();
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 320,
            columnNumber: 11
          }
        }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      }
    });
  }
  if (dataViews.getCanSaveSync()) {
    columns.push(alertColumn);
  }
  const createButton = canSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    onClick: () => setShowCreateDialog(true),
    "data-test-subj": "createDataViewButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.dataViewTable.createBtn",
    defaultMessage: "Create data view",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  if (isLoadingIndexPatterns) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const selection = {
    onSelectionChange: setSelectedItems
  };
  let displayIndexPatternSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: title,
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.dataViewTable.indexPatternExplanation",
      defaultMessage: "Create and manage the data views that help you retrieve your data from Elasticsearch.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 11
      }
    }),
    bottomBorder: true,
    rightSideItems: [createButton],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ContextWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    itemId: "id",
    items: indexPatterns,
    columns: columns,
    pagination: {
      pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    },
    sorting: sorting,
    onTableChange: onTableChange,
    search: search,
    selection: dataViews.getCanSaveSync() ? selection : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 9
    }
  })), flyoutOpen && /*#__PURE__*/_react.default.createElement(_delete_data_view_flyout.DeleteDataViewFlyout, {
    dataViews: dataViews,
    dataViewArray: dataViewArray,
    selectedRelationships: selectedRelationships,
    hasSpaces: !!spaces,
    onDelete: async () => {
      dataViewController.loadDataViews();
      onFlyoutClose();
    },
    onClose: onFlyoutClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 9
    }
  }));
  if (!hasDataView) displayIndexPatternSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPromptNoDataViews.NoDataViewsPromptComponent, {
    onClickCreate: () => setShowCreateDialog(true),
    canCreateNewDataView: application.capabilities.indexPatterns.save,
    dataViewsDocLink: docLinks.links.indexPatterns.introduction,
    onTryESQL: onTryESQL,
    esqlDocLink: docLinks.links.query.queryESQL,
    emptyPromptColor: 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 9
    }
  }));
  if (!hasDataView && !hasESData) displayIndexPatternSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_no_data.NoData, {
    noDataPage: noDataPage,
    docLinks: docLinks,
    uiSettings: uiSettings,
    http: http,
    application: application,
    dataViewController: dataViewController,
    setShowCreateDialog: setShowCreateDialog,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 9
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoadingDataState ? /*#__PURE__*/_react.default.createElement("div", {
    css: {
      display: 'flex',
      justifyContent: 'center'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 11
    }
  })) : displayIndexPatternSection);
};
exports.IndexPatternTable = IndexPatternTable;
const IndexPatternTableWithRouter = exports.IndexPatternTableWithRouter = (0, _reactRouterDom.withRouter)(IndexPatternTable);