"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableWithoutPersist = exports.Table = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/scripted_fields_table/components/table/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE_OPTIONS = [5, 10, 25, 50];
class TableClass extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "renderFormatCell", value => {
      const {
        indexPattern
      } = this.props;
      const title = (0, _lodash.get)(indexPattern, ['fieldFormatMap', value, 'type', 'title'], '');
      return /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 12
        }
      }, title);
    });
  }
  render() {
    const {
      items,
      editField,
      deleteField,
      euiTablePersist: {
        pageSize,
        sorting,
        onTableChange
      }
    } = this.props;
    const columns = [{
      field: 'displayName',
      name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.nameHeader', {
        defaultMessage: 'Name'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.nameDescription', {
        defaultMessage: 'Name of the field'
      }),
      dataType: 'string',
      sortable: true,
      width: '38%'
    }, {
      field: 'lang',
      name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.langHeader', {
        defaultMessage: 'Lang'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.langDescription', {
        defaultMessage: 'Language used for the field'
      }),
      dataType: 'string',
      sortable: true,
      'data-test-subj': 'scriptedFieldLang'
    }, {
      field: 'script',
      name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.scriptHeader', {
        defaultMessage: 'Script'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.scriptDescription', {
        defaultMessage: 'Script for the field'
      }),
      dataType: 'string',
      sortable: true
    }, {
      field: 'name',
      name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.formatHeader', {
        defaultMessage: 'Format'
      }),
      description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.formatDescription', {
        defaultMessage: 'Format used for the field'
      }),
      render: this.renderFormatCell,
      sortable: false
    }, {
      name: '',
      actions: [{
        type: 'icon',
        name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.editHeader', {
          defaultMessage: 'Edit'
        }),
        description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.editDescription', {
          defaultMessage: 'Edit this field'
        }),
        icon: 'pencil',
        onClick: editField,
        available: field => !!field.isUserEditable
      }, {
        type: 'icon',
        name: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.deleteHeader', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.table.deleteDescription', {
          defaultMessage: 'Delete this field'
        }),
        icon: 'trash',
        color: 'danger',
        onClick: deleteField,
        available: field => !!field.isUserEditable
      }],
      width: '40px'
    }];
    const pagination = {
      pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: items,
      columns: columns,
      pagination: pagination,
      sorting: sorting,
      onTableChange: onTableChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    });
  }
}
const TableWithoutPersist = exports.TableWithoutPersist = TableClass; // For testing purposes

const Table = exports.Table = (0, _sharedUxTablePersist.withEuiTablePersist)(TableClass, {
  tableId: 'dataViewsScriptedFields',
  pageSizeOptions: PAGE_SIZE_OPTIONS,
  initialPageSize: 10
});