"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/index_header/index_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const setDefaultAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.setDefaultAria', {
  defaultMessage: 'Set as default data view.'
});
const setDefaultTooltip = _i18n.i18n.translate('indexPatternManagement.editDataView.setDefaultTooltip', {
  defaultMessage: 'Set as default'
});
const editAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.editAria', {
  defaultMessage: 'Edit data view.'
});
const editTooltip = _i18n.i18n.translate('indexPatternManagement.editDataView.editTooltip', {
  defaultMessage: 'Edit'
});
const removeAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.removeAria', {
  defaultMessage: 'Delete data view.'
});
const removeTooltip = _i18n.i18n.translate('indexPatternManagement.editDataView.removeTooltip', {
  defaultMessage: 'Delete'
});
const IndexHeader = ({
  defaultIndex,
  indexPattern,
  setDefault,
  editIndexPatternClick,
  deleteIndexPatternClick,
  children,
  canSave
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "indexPatternTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 18
      }
    }, indexPattern.getName()),
    bottomBorder: true,
    rightSideItems: [canSave && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: editIndexPatternClick,
      iconType: "pencil",
      "aria-label": editAriaLabel,
      "data-test-subj": "editIndexPatternButton",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, editTooltip), defaultIndex !== indexPattern.id && setDefault && canSave && indexPattern.isPersisted() && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: setDefault,
      iconType: "starFilled",
      "aria-label": setDefaultAriaLabel,
      "data-test-subj": "setDefaultIndexPatternButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, setDefaultTooltip), canSave && indexPattern.isPersisted() && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      onClick: deleteIndexPatternClick,
      iconType: "trash",
      "aria-label": removeAriaLabel,
      "data-test-subj": "deleteIndexPatternButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }, removeTooltip)].filter(Boolean),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, children);
};
exports.IndexHeader = IndexHeader;