"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateFromUntrustedUrlRT = exports.getUrlValueFromState = exports.getStateFromUrlValue = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _deep_compact_object = require("../../../common/utils/deep_compact_object");
var _url_schema = require("../../../common/url_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStateFromUrlValue = urlValue => (0, _deep_compact_object.deepCompactObject)({
  dataStream: urlValue.dataStream,
  view: _url_schema.datasetQualityDetailsUrlSchemaV2.isStream(urlValue) ? urlValue.view : undefined,
  timeRange: urlValue.timeRange,
  qualityIssues: urlValue.qualityIssues,
  breakdownField: urlValue.breakdownField,
  showCurrentQualityIssues: urlValue.showCurrentQualityIssues,
  qualityIssuesChart: urlValue.qualityIssuesChart,
  expandedQualityIssue: urlValue.expandedQualityIssue
});
exports.getStateFromUrlValue = getStateFromUrlValue;
const getUrlValueFromState = state => (0, _deep_compact_object.deepCompactObject)({
  dataStream: state.dataStream,
  view: state.view === 'classic' || state.view === 'wired' ? state.view : undefined,
  timeRange: state.timeRange,
  qualityIssues: state.qualityIssues,
  breakdownField: state.breakdownField,
  showCurrentQualityIssues: state.showCurrentQualityIssues,
  qualityIssuesChart: state.qualityIssuesChart,
  expandedQualityIssue: state.expandedQualityIssue,
  v: 2
});
exports.getUrlValueFromState = getUrlValueFromState;
const stateFromUrlSchemaRT = new rt.Type('stateFromUrlSchemaRT', rt.never.is, (urlSchema, _context) => rt.success(getStateFromUrlValue(urlSchema)), getUrlValueFromState);
const stateFromUntrustedUrlRT = exports.stateFromUntrustedUrlRT = _url_schema.datasetQualityDetailsUrlSchemaV2.urlSchemaRT.pipe(stateFromUrlSchemaRT);