"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractPanelsState = extractPanelsState;
var _satisfies = _interopRequireDefault(require("semver/functions/satisfies"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _common = require("../../../../common");
var _kibana_services = require("../../../services/kibana_services");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * We no longer support loading panels from a version older than 7.3 in the URL.
 * @returns whether or not there is a panel in the URL state saved with a version before 7.3
 */
const isPanelVersionTooOld = panels => {
  for (const panel of panels) {
    if (!panel || typeof panel !== 'object' || 'panels' in panel) {
      continue;
    }
    const panelAsObject = panel;
    if (!(panelAsObject.gridData || panelAsObject.grid) || !(panelAsObject.config || panelAsObject.panelConfig || panelAsObject.embeddableConfig) || panelAsObject.version && (0, _satisfies.default)(panelAsObject.version, '<7.3')) return true;
  }
  return false;
};
function extractPanelsState(state) {
  const panels = Array.isArray(state.panels) ? state.panels : [];
  if (panels.length === 0) {
    return {};
  }
  if (isPanelVersionTooOld(panels)) {
    _kibana_services.coreServices.notifications.toasts.addWarning((0, _dashboard_app_strings.getPanelTooOldErrorString)());
    return {};
  }
  const savedObjectReferences = [];
  const standardizedPanels = panels.map(legacyPanel => {
    const panel = typeof legacyPanel === 'object' ? {
      ...legacyPanel
    } : {};
    if (panel.panels) {
      const {
        panels: sectionPanels,
        savedObjectReferences: sectionPanelReferences
      } = extractPanelsState({
        panels: panel.panels
      });
      savedObjectReferences.push(...(sectionPanelReferences !== null && sectionPanelReferences !== void 0 ? sectionPanelReferences : []));
      panel.panels = sectionPanels;
    }

    // < 8.17 panels state stored panelConfig as embeddableConfig
    if (panel !== null && panel !== void 0 && panel.embeddableConfig) {
      panel.config = panel.embeddableConfig;
      delete panel.embeddableConfig;
    }

    // < 9.3 panels state stored config as panelConfig
    if (panel !== null && panel !== void 0 && panel.panelConfig) {
      panel.config = panel.panelConfig;
      delete panel.panelConfig;
    }

    // < 9.3 grid stored as gridData
    if (panel !== null && panel !== void 0 && panel.gridData) {
      panel.grid = panel.gridData;
      delete panel.gridData;
    }

    // < 9.3 uid stored as panelIndex
    if (panel !== null && panel !== void 0 && panel.panelIndex) {
      panel.uid = panel.panelIndex;
      delete panel.panelIndex;
    }

    // <8.19 'id' (saved object id) stored as siblings to config
    if (panel.id && panel.config && typeof panel.config === 'object') {
      panel.config.savedObjectId = panel.id;
      delete panel.id;
    }

    // <8.19 'title' stored as siblings to config
    if (panel.title && panel.config && typeof panel.config === 'object') {
      panel.config.title = panel.title;
      delete panel.title;
    }

    // < 9.2 dashboard managed saved object refs for panels
    // Add saved object ref for panels that contain savedObjectId
    // TODO remove once all panels inject references in dashboard server api
    const {
      config,
      uid,
      type
    } = panel;
    if (uid && type && config !== null && config !== void 0 && config.savedObjectId && typeof (config === null || config === void 0 ? void 0 : config.savedObjectId) === 'string') {
      savedObjectReferences.push(...(0, _common.prefixReferencesFromPanel)(uid, [{
        id: config.savedObjectId,
        name: _presentationPublishing.SAVED_OBJECT_REF_NAME,
        type
      }]));
    }
    return panel;
  });
  return {
    panels: standardizedPanels,
    savedObjectReferences: savedObjectReferences.length ? savedObjectReferences : undefined
  };
}