"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateNewPanelIds = generateNewPanelIds;
var _uuid = require("uuid");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function generateNewPanelIds(panels, references) {
  const newPanels = [];
  const newPanelReferences = [];
  function generateNewPanelId(panel) {
    var _panel$uid;
    const newPanelId = (0, _uuid.v4)();
    const oldPanelId = (_panel$uid = panel.uid) !== null && _panel$uid !== void 0 ? _panel$uid : panel.grid.i;
    const panelReferences = oldPanelId && references ? (0, _common.getReferencesForPanelId)(oldPanelId, references) : [];
    newPanelReferences.push(...(0, _common.prefixReferencesFromPanel)(newPanelId, panelReferences));
    return {
      ...panel,
      uid: newPanelId,
      grid: {
        ...panel.grid,
        i: newPanelId
      }
    };
  }
  for (const panel of panels) {
    if ((0, _common.isDashboardSection)(panel)) {
      const section = panel;
      const newSectionId = (0, _uuid.v4)();
      newPanels.push({
        ...section,
        grid: {
          ...section.grid,
          i: newSectionId
        },
        panels: section.panels.map(panelInSection => {
          return generateNewPanelId(panelInSection);
        })
      });
    } else {
      newPanels.push(generateNewPanelId(panel));
    }
  }
  return {
    newPanels,
    newPanelReferences
  };
}