"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.init = init;
exports.trackUiMetric = void 0;
exports.trackUserRequest = trackUserRequest;
var _analytics = require("@kbn/analytics");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// usageCollection is an optional dependency, so we default to a no-op.
let trackUiMetric = (metricType, eventName) => {};
exports.trackUiMetric = trackUiMetric;
function init(usageCollection) {
  exports.trackUiMetric = trackUiMetric = usageCollection.reportUiCounter.bind(usageCollection, _constants.UIM_APP_NAME);
}

/**
 * Transparently return provided request Promise, while allowing us to track
 * a successful completion of the request.
 */
function trackUserRequest(request, actionType) {
  // Only track successful actions.
  return request.then(response => {
    // It looks like we're using the wrong type here, added via
    // https://github.com/elastic/kibana/pull/41113/files#diff-e65a0a6696a9d723969afd871cbd60cdR19
    // but we'll keep it for now to avoid discontinuity in our telemetry data.
    trackUiMetric(_analytics.METRIC_TYPE.LOADED, actionType);

    // We return the response immediately without waiting for the tracking request to resolve,
    // to avoid adding additional latency.
    return response;
  });
}