"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFields = exports.FormEntryRow = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/components/form_entry_row.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * State transitions: fields update
 */
const updateFields = newValues => ({
  fields
}) => ({
  fields: {
    ...fields,
    ...newValues
  }
});
exports.updateFields = updateFields;
class FormEntryRow extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onFieldChange", value => {
      const {
        field,
        onValueUpdate,
        type
      } = this.props;
      const isNumber = type === 'number';
      let valueParsed = value;
      if (isNumber) {
        valueParsed = !!value ? Math.max(0, parseInt(value, 10)) : value; // make sure we don't send NaN value or a negative number
      }
      onValueUpdate({
        [field]: valueParsed
      });
    });
    (0, _defineProperty2.default)(this, "renderField", isInvalid => {
      const {
        value,
        type,
        disabled,
        isLoading,
        testSubj
      } = this.props;
      switch (type) {
        case 'number':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
            isInvalid: isInvalid,
            value: value,
            onChange: e => this.onFieldChange(e.target.value),
            disabled: disabled === true,
            isLoading: isLoading,
            fullWidth: true,
            "data-test-subj": testSubj,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 68,
              columnNumber: 11
            }
          });
        default:
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
            isInvalid: isInvalid,
            value: value,
            onChange: e => this.onFieldChange(e.target.value),
            disabled: disabled === true,
            isLoading: isLoading,
            fullWidth: true,
            "data-test-subj": testSubj,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 80,
              columnNumber: 11
            }
          });
      }
    });
  }
  render() {
    const {
      field,
      error,
      title,
      label,
      description,
      helpText,
      areErrorsVisible,
      value,
      defaultValue
    } = this.props;
    const hasError = !!error;
    const isInvalid = hasError && (error.alwaysVisible || areErrorsVisible);
    const canBeResetToDefault = defaultValue !== undefined;
    const isResetToDefaultVisible = value !== defaultValue;
    const fieldHelpText = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    }, helpText, canBeResetToDefault && isResetToDefaultVisible && /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => this.onFieldChange(defaultValue),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexForm.resetFieldButtonLabel",
      defaultMessage: "Reset to default",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 15
      }
    }))));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
      title: title,
      description: description,
      fullWidth: true,
      key: field,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      helpText: fieldHelpText,
      error: error && error.message ? error.message : error,
      isInvalid: isInvalid,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }, this.renderField(isInvalid)));
  }
}
exports.FormEntryRow = FormEntryRow;
(0, _defineProperty2.default)(FormEntryRow, "propTypes", {
  title: _propTypes.default.node,
  description: _propTypes.default.node,
  label: _propTypes.default.node,
  helpText: _propTypes.default.node,
  type: _propTypes.default.string,
  onValueUpdate: _propTypes.default.func.isRequired,
  field: _propTypes.default.string.isRequired,
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired,
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  isLoading: _propTypes.default.bool,
  error: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.object]),
  disabled: _propTypes.default.bool,
  areErrorsVisible: _propTypes.default.bool.isRequired,
  testSubj: _propTypes.default.string
});