"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createModelVersionTestMigrator = void 0;
var _loggingMocks = require("@kbn/logging-mocks");
var _configMocks = require("@kbn/config-mocks");
var _config = require("@kbn/config");
var _repoInfo = require("@kbn/repo-info");
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _coreSavedObjectsMigrationServerInternal = require("@kbn/core-saved-objects-migration-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const env = _config.Env.createDefault(_repoInfo.REPO_ROOT, (0, _configMocks.getEnvOptions)());
const currentVersion = env.packageInfo.version;
const lastCoreVersion = '8.8.0';

/**
 * Options for {@link ModelVersionTestMigrator.migrate}
 */

/**
 * Test utility allowing to test model version changes between versions.
 */

/**
 * Create a {@link ModelVersionTestMigrator | test migrator} that can be used
 * to test model version changes between versions.
 *
 * @example
 * ```ts
 * const mySoType = someSoType();
 * const migrator = createModelVersionTestMigrator({ type: mySoType });
 *
 * const obj = createSomeSavedObject();
 *
 * const migrated = migrator.migrate({
 *    document: obj,
 *    fromVersion: 1,
 *    toVersion: 2,
 * });
 *
 * expect(migrated.properties).toEqual(myExpectedProperties);
 * ```
 */
const createModelVersionTestMigrator = ({
  type
}) => {
  const typeRegistry = new _coreSavedObjectsBaseServerInternal.SavedObjectTypeRegistry();
  typeRegistry.registerType(type);
  const logger = _loggingMocks.loggerMock.create();
  const migrator = new _coreSavedObjectsMigrationServerInternal.DocumentMigrator({
    typeRegistry,
    log: logger,
    kibanaVersion: currentVersion
  });
  migrator.prepareMigrations();
  return {
    migrate: ({
      document,
      fromVersion,
      toVersion
    }) => {
      const docCopy = {
        ...document,
        coreMigrationVersion: lastCoreVersion,
        typeMigrationVersion: (0, _coreSavedObjectsBaseServerInternal.modelVersionToVirtualVersion)(fromVersion)
      };
      const migratedDoc = migrator.migrate(docCopy, {
        allowDowngrade: true,
        targetTypeVersion: (0, _coreSavedObjectsBaseServerInternal.modelVersionToVirtualVersion)(toVersion)
      });
      return migratedDoc;
    }
  };
};
exports.createModelVersionTestMigrator = createModelVersionTestMigrator;