"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeRetentionPolicyConfig = exports.createRetentionPolicy = void 0;
var _retention_policy = require("./retention_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createRetentionPolicy = (config, context) => {
  return new _retention_policy.GenericRetentionPolicy(config, context);
};
exports.createRetentionPolicy = createRetentionPolicy;
const mergeRetentionPolicyConfig = (config, strategyConfig) => {
  return {
    ...config,
    maxFiles: (config === null || config === void 0 ? void 0 : config.maxFiles) || strategyConfig.max
  };
};
exports.mergeRetentionPolicyConfig = mergeRetentionPolicyConfig;