"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.focusMainContent = void 0;
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Utility function for focusing the main Kibana content.
 */
const focusMainContent = () => {
  const mainElement = document.querySelector(_coreChromeLayoutConstants.MAIN_CONTENT_SELECTORS.join(','));
  if (mainElement instanceof HTMLElement) {
    mainElement.focus();
  }
};
exports.focusMainContent = focusMainContent;