"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Panel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _secondary_menu = require("../secondary_menu");
var _use_nested_menu = require("./use_nested_menu");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/core/packages/chrome/navigation/src/components/nested_secondary_menu/menu_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Panel = ({
  children,
  id,
  title
}) => {
  const {
    currentPanel,
    panelStackDepth,
    returnFocusId
  } = (0, _use_nested_menu.useNestedMenu)();
  const panelNavigationInstructionsId = (0, _eui.useGeneratedHtmlId)({
    prefix: `panel-navigation-instructions-${id}`
  });
  const panelEnterSubmenuInstructionsId = (0, _eui.useGeneratedHtmlId)({
    prefix: `panel-enter-submenu-instructions-${id}`
  });
  const isRootPanel = panelStackDepth === 0;
  const navigationInstructions = isRootPanel ? _i18n.i18n.translate('core.ui.chrome.sideNavigation.morePanelInstructions', {
    defaultMessage: 'You are in the More primary menu dialog. Use Up and Down arrow keys to navigate. Press Escape to exit to the menu trigger.'
  }) : _i18n.i18n.translate('core.ui.chrome.sideNavigation.nestedPanelInstructions', {
    defaultMessage: 'You are in a submenu. Use Up and Down arrow keys to navigate. Press Go back or Escape to exit to the parent menu.'
  });
  const enterSubmenuInstructions = _i18n.i18n.translate('core.ui.chrome.sideNavigation.panelEnterSubmenuInstruction', {
    defaultMessage: 'Press Enter to go to the submenu.'
  });
  const panelRef = (0, _react.useCallback)(node => {
    if (currentPanel !== id) return;

    // If we have a return focus id, we focus the trigger element
    if (returnFocusId && node) {
      const triggerElement = node.querySelector(`#${CSS.escape(returnFocusId)}`);
      if (triggerElement) return triggerElement.focus();
    }

    // If we are at the root panel, we don't need to focus anything
    if (isRootPanel) return;

    // Otherwise, we focus the first focusable element in the panel
    if (node) {
      var _elements$;
      const elements = (0, _get_focusable_elements.getFocusableElements)(node);
      (_elements$ = elements[0]) === null || _elements$ === void 0 ? void 0 : _elements$.focus();
    }
  }, [currentPanel, id, isRootPanel, returnFocusId]);
  const renderChildren = () => {
    if (typeof children === 'function') {
      return children({
        panelNavigationInstructionsId,
        panelEnterSubmenuInstructionsId
      });
    }
    return children;
  };
  if (currentPanel !== id) return null;
  if (title) {
    return /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu, {
      "data-test-subj": `nestedSecondaryMenuPanel-${id}`,
      ref: panelRef,
      title: title,
      isPanel: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      id: panelNavigationInstructionsId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, navigationInstructions)), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      id: panelEnterSubmenuInstructionsId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, enterSubmenuInstructions)), renderChildren());
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `nestedSecondaryMenuPanel-${id}`,
    ref: panelRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    id: panelNavigationInstructionsId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, navigationInstructions)), renderChildren());
};
exports.Panel = Panel;