"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridLayout = void 0;
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _coreChromeLayoutComponents = require("@kbn/core-chrome-layout-components");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _grid_global_app_style = require("./grid_global_app_style");
var _app_containers = require("../../app_containers");
var _app_fixed_viewport = require("../../app_fixed_viewport");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/core/packages/chrome/layout/core-chrome-layout/layouts/grid/grid_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const layoutConfigs = {
  classic: {
    headerHeight: 96,
    bannerHeight: 32,
    /** for debug for now */
    sidebarWidth: 48,
    footerHeight: 48,
    navigationWidth: 48
  },
  project: {
    headerHeight: 48,
    bannerHeight: 32,
    /** The application top bar renders the app specific menu */
    /** we use it only in project style, because in classic it is included as part of the global header */
    applicationTopBarHeight: 48,
    /** for debug for now */
    sidebarWidth: 48,
    footerHeight: 48,
    navigationWidth: 48
  }
};

/**
 * Service for providing layout component wired to other core services.
 */
class GridLayout {
  constructor(deps, params) {
    this.deps = deps;
    this.params = params;
  }

  /**
   * Returns a layout component with the provided dependencies
   */
  getComponent() {
    var _this$params$debug;
    const {
      application,
      chrome,
      overlays
    } = this.deps;
    const appComponent = application.getComponent();
    const appBannerComponent = overlays.banners.getComponent();
    const hasHeaderBanner$ = chrome.hasHeaderBanner$();
    const chromeVisible$ = chrome.getIsVisible$();
    const chromeStyle$ = chrome.getChromeStyle$();
    const debug = (_this$params$debug = this.params.debug) !== null && _this$params$debug !== void 0 ? _this$params$debug : false;
    const v2ProjectSideNavEnabled = this.params.projectSideNavVersion === 'v2';
    const classicChromeHeader = chrome.getClassicHeaderComponentForGridLayout();
    const projectChromeHeader = chrome.getProjectHeaderComponentForGridLayout({
      // for v2 project side navigation we don't need to include the side navigation in the header,
      // because it is rendered separately in the nav grid cell
      includeSideNav: v2ProjectSideNavEnabled ? false : 'v1'
    });
    const headerBanner = chrome.getHeaderBanner();

    // chromeless header is used when chrome is not visible and responsible for displaying the data-test-subj and fixed loading bar
    const chromelessHeader = chrome.getChromelessHeader();

    // in project style, the project app menu is displayed at the top of application area
    const projectAppMenu = chrome.getProjectAppMenuComponent();
    const hasAppMenu$ = application.currentActionMenu$.pipe((0, _rxjs.map)(menu => !!menu));
    const projectSideNavigationV2 = chrome.getProjectSideNavV2ComponentForGridLayout();
    return /*#__PURE__*/_react.default.memo(() => {
      // TODO: Get rid of observables https://github.com/elastic/kibana/issues/225265
      const chromeVisible = (0, _useObservable.default)(chromeVisible$, false);
      const hasHeaderBanner = (0, _useObservable.default)(hasHeaderBanner$, false);
      const chromeStyle = (0, _useObservable.default)(chromeStyle$, 'classic');
      const hasAppMenu = (0, _useObservable.default)(hasAppMenu$, false);
      const layoutConfig = layoutConfigs[chromeStyle];

      // Assign main layout parts first
      let header;
      let navigation;
      let banner;
      let applicationTopBar;
      // not implemented, just for debug
      let sidebar;
      let footer;
      if (chromeVisible) {
        if (chromeStyle === 'classic') {
          // If classic style, we use the classic header and no navigation, since it is part of the header
          header = classicChromeHeader;
        } else {
          // If project style, we use the project header and navigation
          header = projectChromeHeader;
          if (hasAppMenu) {
            // If project app menu is present, we use it as the application top bar
            applicationTopBar = projectAppMenu;
          }
          if (v2ProjectSideNavEnabled) {
            navigation = projectSideNavigationV2;
          }
        }
      }
      if (hasHeaderBanner) {
        // If header banner is present, we use it, even if chrome is not visible
        banner = headerBanner;
      }

      // If debug, override/add debug overlays
      if (debug) {
        if (chromeVisible) {
          if (!sidebar) sidebar = /*#__PURE__*/_react.default.createElement(_coreChromeLayoutComponents.SimpleDebugOverlay, {
            label: "Debug Sidebar",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 138,
              columnNumber: 35
            }
          });
          if (!footer) footer = /*#__PURE__*/_react.default.createElement(_coreChromeLayoutComponents.SimpleDebugOverlay, {
            label: "Debug Footer",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 139,
              columnNumber: 33
            }
          });
          if (!navigation) {
            navigation = /*#__PURE__*/_react.default.createElement(_coreChromeLayoutComponents.SimpleDebugOverlay, {
              label: "Debug Navigation",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 141,
                columnNumber: 26
              }
            });
          }
        }
        // banner is visible even when chrome is not visible
        if (!banner) {
          banner = /*#__PURE__*/_react.default.createElement(_coreChromeLayoutComponents.SimpleDebugOverlay, {
            label: "Debug Banner",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 146,
              columnNumber: 20
            }
          });
        }
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_grid_global_app_style.GridLayoutGlobalStyles, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_coreChromeLayoutComponents.ChromeLayoutConfigProvider, {
        value: layoutConfig,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_coreChromeLayoutComponents.ChromeLayout, {
        header: header,
        sidebar: sidebar,
        footer: footer,
        navigation: navigation,
        banner: banner,
        applicationTopBar: applicationTopBar,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !chromeVisible && chromelessHeader, /*#__PURE__*/_react.default.createElement("div", {
        id: "globalBannerList",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 17
        }
      }, appBannerComponent), /*#__PURE__*/_react.default.createElement(_app_containers.AppWrapper, {
        chromeVisible: chromeVisible,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: _app_fixed_viewport.APP_FIXED_VIEWPORT_ID,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 19
        }
      }), appComponent)))));
    });
  }
}
exports.GridLayout = GridLayout;