"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSideNavVersion = exports.getLayoutVersion = exports.getLayoutDebugFlag = exports.LAYOUT_PROJECT_SIDENAV_FEATURE_FLAG_KEY = exports.LAYOUT_FEATURE_FLAG_KEY = exports.LAYOUT_DEBUG_FEATURE_FLAG_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LAYOUT_FEATURE_FLAG_KEY = exports.LAYOUT_FEATURE_FLAG_KEY = 'core.chrome.layoutType';
const LAYOUT_DEBUG_FEATURE_FLAG_KEY = exports.LAYOUT_DEBUG_FEATURE_FLAG_KEY = 'core.chrome.layoutDebug';
const LAYOUT_PROJECT_SIDENAV_FEATURE_FLAG_KEY = exports.LAYOUT_PROJECT_SIDENAV_FEATURE_FLAG_KEY = 'core.chrome.projectSideNav';
const getSideNavVersion = featureFlags => {
  const featureFlag = featureFlags.getStringValue(LAYOUT_PROJECT_SIDENAV_FEATURE_FLAG_KEY, 'v2');

  // both is temporarily supported hidden option to allow for a smooth transition
  if (featureFlag !== 'v1' && featureFlag !== 'v2' && featureFlag !== 'both') {
    throw new Error(`Invalid project side nav feature flag value: ${featureFlag}. Expected 'v1' or 'v2'.`);
  }
  return featureFlag;
};
exports.getSideNavVersion = getSideNavVersion;
const getLayoutVersion = featureFlags => {
  const featureFlag = featureFlags.getStringValue(LAYOUT_FEATURE_FLAG_KEY, 'legacy-fixed');
  if (featureFlag !== 'legacy-fixed' && featureFlag !== 'grid') {
    throw new Error(`Invalid layout feature flag value: ${featureFlag}. Expected 'legacy-fixed' or 'grid'.`);
  }
  return featureFlag;
};
exports.getLayoutVersion = getLayoutVersion;
const getLayoutDebugFlag = featureFlags => {
  return featureFlags.getBooleanValue(LAYOUT_DEBUG_FEATURE_FLAG_KEY, false);
};
exports.getLayoutDebugFlag = getLayoutDebugFlag;