"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appendAppPath = void 0;
var _remove_slashes = require("./remove_slashes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const appendAppPath = (appBasePath = '', path = '') => {
  // Only prepend slash if not a hash or query path
  path = path === '' || path.startsWith('#') || path.startsWith('?') ? path : `/${path}`;
  // Do not remove trailing slash when in hashbang or basePath
  const removeTrailing = path.indexOf('#') === -1 && appBasePath.indexOf('#') === -1;
  return (0, _remove_slashes.removeSlashes)(`${appBasePath}${path}`, {
    trailing: removeTrailing,
    duplicates: true,
    leading: false
  });
};
exports.appendAppPath = appendAppPath;