"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSourceMappingsProperties = void 0;
var _lodash = require("lodash");
var TaskEither = _interopRequireWildcard(require("fp-ts/TaskEither"));
var _function = require("fp-ts/function");
var _diff_mappings = require("../core/diff_mappings");
var _update_mappings = require("./update_mappings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/**
 * This action tries to update the source mappings properties if there are any changes.
 * @internal
 */
const updateSourceMappingsProperties = ({
  client,
  sourceIndex,
  indexMappings,
  appMappings,
  indexTypes,
  latestMappingsVersions,
  hashToVersionMap
}) => {
  return (0, _function.pipe)((0, _diff_mappings.diffMappings)({
    indexMappings,
    appMappings,
    indexTypes,
    latestMappingsVersions,
    hashToVersionMap
  }), TaskEither.fromPredicate(changes => !!changes, () => 'update_mappings_succeeded'), TaskEither.swap, TaskEither.orElse(() => (0, _update_mappings.updateMappings)({
    client,
    index: sourceIndex,
    mappings: (0, _lodash.omit)(appMappings, ['_meta']) // ._meta property will be updated on a later step
  })));
};
exports.updateSourceMappingsProperties = updateSourceMappingsProperties;