"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsTypeRegistry = exports.SavedObjectsClientFactory = exports.SavedObjectsClient = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Factory type for creating parameterized Saved Objects client instances.
 * @see {@link SavedObjectsClientContract}
 * @public
 */

/**
 * The Saved Objects client instance in the current HTTP request context.
 * @see {@link SavedObjectsClientContract}
 * @public
 */
const SavedObjectsClient = exports.SavedObjectsClient = Symbol('SavedObjectsClient');

/**
 * The Saved Objects client factory that constructs a client instance the current HTTP request context.
 * @public
 */
const SavedObjectsClientFactory = exports.SavedObjectsClientFactory = Symbol('SavedObjectsClientFactory');

/**
 * The Saved Objects type registry.
 * @see {@link ISavedObjectTypeRegistry}
 * @public
 */
const SavedObjectsTypeRegistry = exports.SavedObjectsTypeRegistry = Symbol('SavedObjectsTypeRegistry');