"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverSortingButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _suggestions_sorting = require("../../../../../common/options_list/suggestions_sorting");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_strings = require("../options_list_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/options_list_control/components/options_list_popover_sorting_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sortOrderOptions = [{
  id: 'asc',
  iconType: `sortAscending`,
  'data-test-subj': `optionsList__sortOrder_asc`,
  label: _options_list_strings.OptionsListStrings.editorAndPopover.sortOrder.asc.getSortOrderLabel()
}, {
  id: 'desc',
  iconType: `sortDescending`,
  'data-test-subj': `optionsList__sortOrder_desc`,
  label: _options_list_strings.OptionsListStrings.editorAndPopover.sortOrder.desc.getSortOrderLabel()
}];
const panelStyle = {
  width: '224px'
};
const OptionsListPopoverSortingButton = ({
  showOnlySelected
}) => {
  var _selectedSort$directi;
  const {
    componentApi
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [isSortingPopoverOpen, setIsSortingPopoverOpen] = (0, _react.useState)(false);
  const [sort, field] = (0, _presentationPublishing.useBatchedPublishingSubjects)(componentApi.sort$, componentApi.field$);
  const selectedSort = (0, _react.useMemo)(() => sort !== null && sort !== void 0 ? sort : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT, [sort]);
  const [sortByOptions, setSortByOptions] = (0, _react.useState)(() => {
    return (0, _suggestions_sorting.getCompatibleSortingTypes)(field === null || field === void 0 ? void 0 : field.type).map(key => {
      return {
        onFocusBadge: false,
        data: {
          sortBy: key
        },
        checked: key === selectedSort.by ? 'on' : undefined,
        'data-test-subj': `optionsList__sortBy_${key}`,
        label: _options_list_strings.OptionsListStrings.editorAndPopover.sortBy[key].getSortByLabel(field === null || field === void 0 ? void 0 : field.type)
      };
    });
  });
  const onSortByChange = (0, _react.useCallback)(updatedOptions => {
    setSortByOptions(updatedOptions);
    const selectedOption = updatedOptions.find(({
      checked
    }) => checked === 'on');
    if (selectedOption) {
      componentApi.setSort({
        ...selectedSort,
        by: selectedOption.data.sortBy
      });
    }
  }, [selectedSort, componentApi]);
  const SortButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    display: "empty",
    color: "text",
    iconType: selectedSort.direction === 'asc' ? 'sortAscending' : 'sortDescending',
    isDisabled: showOnlySelected,
    className: "optionsList__sortButton",
    "data-test-subj": "optionsListControl__sortingOptionsButton",
    onClick: () => setIsSortingPopoverOpen(!isSortingPopoverOpen),
    "aria-label": _options_list_strings.OptionsListStrings.popover.getSortPopoverDescription(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: showOnlySelected ? _options_list_strings.OptionsListStrings.popover.getSortDisabledTooltip() : _options_list_strings.OptionsListStrings.popover.getSortPopoverTitle(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(SortButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    })),
    panelPaddingSize: "none",
    isOpen: isSortingPopoverOpen,
    "aria-labelledby": "optionsList_sortingOptions",
    closePopover: () => setIsSortingPopoverOpen(false),
    panelStyle: panelStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "optionsListControl__sortingOptionsPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, _options_list_strings.OptionsListStrings.popover.getSortPopoverTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isIconOnly: true,
    buttonSize: "compressed",
    options: sortOrderOptions,
    idSelected: (_selectedSort$directi = selectedSort.direction) !== null && _selectedSort$directi !== void 0 ? _selectedSort$directi : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.direction,
    legend: _options_list_strings.OptionsListStrings.editorAndPopover.getSortDirectionLegend(),
    onChange: value => {
      componentApi.setSort({
        ...selectedSort,
        direction: value
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: sortByOptions,
    singleSelection: "always",
    onChange: onSortByChange,
    id: "optionsList_sortingOptions",
    listProps: {
      bordered: false
    },
    "data-test-subj": "optionsListControl__sortingOptions",
    "aria-label": _options_list_strings.OptionsListStrings.popover.getSortPopoverDescription(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, list => list)));
};
exports.OptionsListPopoverSortingButton = OptionsListPopoverSortingButton;