"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initSelectionsManager = initSelectionsManager;
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initSelectionsManager(controlGroupApi) {
  const filters$ = new _rxjs.BehaviorSubject([]);
  const unpublishedFilters$ = new _rxjs.BehaviorSubject([]);
  const timeslice$ = new _rxjs.BehaviorSubject(undefined);
  const unpublishedTimeslice$ = new _rxjs.BehaviorSubject(undefined);
  const hasUnappliedSelections$ = new _rxjs.BehaviorSubject(false);
  const filtersPublished = new _rxjs.BehaviorSubject(false);
  const untilFiltersPublished = () => new Promise(resolve => {
    filtersPublished.pipe((0, _rxjs.first)(isComplete => isComplete)).subscribe(() => {
      resolve();
      filtersPublished.complete();
    });
  });
  const subscriptions = [];
  controlGroupApi.untilInitialized().then(() => {
    const initialFilters = [];
    let initialTimeslice;
    Object.values(controlGroupApi.children$.value).forEach(controlApi => {
      if ((0, _presentationPublishing.apiPublishesFilters)(controlApi) && controlApi.filters$.value) {
        initialFilters.push(...controlApi.filters$.value);
      }
      if ((0, _presentationPublishing.apiPublishesTimeslice)(controlApi) && controlApi.timeslice$.value) {
        initialTimeslice = controlApi.timeslice$.value;
      }
    });
    if (initialFilters.length) {
      filters$.next(initialFilters);
      unpublishedFilters$.next(initialFilters);
    }
    if (initialTimeslice) {
      timeslice$.next(initialTimeslice);
      unpublishedTimeslice$.next(initialTimeslice);
    }
    subscriptions.push((0, _presentationContainers.combineCompatibleChildrenApis)(controlGroupApi, 'filters$', _presentationPublishing.apiPublishesFilters, []).subscribe(newFilters => unpublishedFilters$.next(newFilters)));
    subscriptions.push((0, _presentationContainers.combineCompatibleChildrenApis)(controlGroupApi, 'timeslice$', _presentationPublishing.apiPublishesTimeslice, undefined,
    // flatten method
    values => {
      // control group should never allow multiple timeslider controls
      // return last timeslider control value
      return values.length === 0 ? undefined : values[values.length - 1];
    }).subscribe(newTimeslice => unpublishedTimeslice$.next(newTimeslice)));
    subscriptions.push((0, _rxjs.combineLatest)([filters$, unpublishedFilters$, timeslice$, unpublishedTimeslice$]).subscribe(([filters, unpublishedFilters, timeslice, unpublishedTimeslice]) => {
      const next = !(0, _fastDeepEqual.default)(timeslice, unpublishedTimeslice) || !(0, _fastDeepEqual.default)(filters, unpublishedFilters);
      if (hasUnappliedSelections$.value !== next) {
        hasUnappliedSelections$.next(next);
      }
    }));
    subscriptions.push((0, _rxjs.combineLatest)([controlGroupApi.autoApplySelections$, unpublishedFilters$, unpublishedTimeslice$]).subscribe(([autoApplySelections]) => {
      if (autoApplySelections) {
        applySelections();
      }
    }));
    filtersPublished.next(true);
  });
  function applySelections() {
    if (!(0, _fastDeepEqual.default)(filters$.value, unpublishedFilters$.value)) {
      filters$.next(unpublishedFilters$.value);
    }
    if (!(0, _fastDeepEqual.default)(timeslice$.value, unpublishedTimeslice$.value)) {
      timeslice$.next(unpublishedTimeslice$.value);
    }
  }
  return {
    api: {
      filters$,
      timeslice$,
      untilFiltersPublished
    },
    applySelections,
    cleanup: () => {
      subscriptions.forEach(subscription => subscription.unsubscribe());
    },
    hasUnappliedSelections$
  };
}