"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compatibilityCheck = exports.DeleteControlAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _controlsConstants = require("@kbn/controls-constants");
var _constants = require("./constants");
var _common = require("../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/controls/public/actions/delete_control_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const compatibilityCheck = api => Boolean((0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api.parentApi) && (0, _presentationPublishing.apiIsOfType)(api.parentApi, _controlsConstants.CONTROLS_GROUP_TYPE) && (0, _presentationContainers.apiIsPresentationContainer)(api.parentApi));
exports.compatibilityCheck = compatibilityCheck;
class DeleteControlAction {
  // should always be last

  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_DELETE_CONTROL);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_DELETE_CONTROL);
    (0, _defineProperty2.default)(this, "order", 100);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: this.getDisplayName(context),
        disableScreenReaderOutput: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `control-action-${context.embeddable.uuid}-delete`,
        "aria-label": this.getDisplayName(context),
        iconType: this.getIconType(context),
        onClick: () => this.execute(context),
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 9
        }
      }));
    });
  }
  getDisplayName({
    embeddable
  }) {
    return _i18n.i18n.translate('controls.controlGroup.floatingActions.removeTitle', {
      defaultMessage: 'Delete'
    });
  }
  getIconType({
    embeddable
  }) {
    return 'trash';
  }
  async isCompatible({
    embeddable
  }) {
    return compatibilityCheck(embeddable) && (0, _presentationPublishing.getInheritedViewMode)(embeddable.parentApi) === 'edit';
  }
  async execute({
    embeddable
  }) {
    if (!compatibilityCheck(embeddable)) throw new _public.IncompatibleActionError();
    (0, _common.confirmDeleteControl)().then(confirmed => {
      if (confirmed) {
        embeddable.parentApi.removePanel(embeddable.uuid);
      }
    });
  }
}
exports.DeleteControlAction = DeleteControlAction;