"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _content_client = require("./content_client");
var _registry = require("./registry");
var _rpc_client = require("./rpc_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ContentManagementPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "contentTypeRegistry", void 0);
    this.contentTypeRegistry = new _registry.ContentTypeRegistry();
  }
  setup() {
    return {
      registry: {
        register: this.contentTypeRegistry.register.bind(this.contentTypeRegistry)
      }
    };
  }
  start(core, deps) {
    const rpcClient = new _rpc_client.RpcClient(core.http);
    const contentClient = new _content_client.ContentClient(contentType => {
      var _this$contentTypeRegi, _this$contentTypeRegi2;
      if (!contentType) return rpcClient;
      return (_this$contentTypeRegi = (_this$contentTypeRegi2 = this.contentTypeRegistry.get(contentType)) === null || _this$contentTypeRegi2 === void 0 ? void 0 : _this$contentTypeRegi2.crud) !== null && _this$contentTypeRegi !== void 0 ? _this$contentTypeRegi : rpcClient;
    }, this.contentTypeRegistry);
    return {
      client: contentClient,
      registry: {
        get: this.contentTypeRegistry.get.bind(this.contentTypeRegistry),
        getAll: this.contentTypeRegistry.getAll.bind(this.contentTypeRegistry)
      }
    };
  }
}
exports.ContentManagementPlugin = ContentManagementPlugin;