"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.versionSchema = exports.procedureNames = void 0;
var _configSchema = require("@kbn/config-schema");
var _objectVersioningUtils = require("@kbn/object-versioning-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const procedureNames = exports.procedureNames = ['get', 'bulkGet', 'create', 'update', 'delete', 'search', 'mSearch'];
const versionSchema = exports.versionSchema = _configSchema.schema.number({
  validate: value => {
    const {
      result
    } = (0, _objectVersioningUtils.validateVersion)(value);
    if (!result) {
      return 'must be an integer';
    }
  }
});