"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentlessConnectorStatusBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connector_detail/agentless_status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentlessConnectorStatusBadge = ({
  status,
  ...restOfProps
}) => {
  switch (status) {
    case 'error':
    case 'degraded':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "warning"
      }, restOfProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.unhealthyStatusText",
        defaultMessage: "Unhealthy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 26,
          columnNumber: 11
        }
      }));
    case 'inactive':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: _uiTheme.euiLightVars.euiColorDarkShade
      }, restOfProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.inactiveStatusText",
        defaultMessage: "Inactive",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 11
        }
      }));
    case 'offline':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "default"
      }, restOfProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.offlineStatusText",
        defaultMessage: "Offline",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 11
        }
      }));
    case 'uninstalled':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "default"
      }, restOfProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.uninstalledStatusText",
        defaultMessage: "Uninstalled",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }));
    case 'orphaned':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "warning"
      }, restOfProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.orphanedStatusText",
        defaultMessage: "Orphaned",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 11
        }
      }));
    case 'unenrolling':
    case 'enrolling':
    case 'updating':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "primary"
      }, restOfProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.updatingStatusText",
        defaultMessage: "Updating",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 11
        }
      }));
    case 'unenrolled':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: _uiTheme.euiLightVars.euiColorDisabled
      }, restOfProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.unenrolledStatusText",
        defaultMessage: "Unenrolled",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      }));
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "success"
      }, restOfProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.contentConnectors.connectors.elasticManaged.agentHealth.healthyStatusText",
        defaultMessage: "Healthy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }));
  }
};
exports.AgentlessConnectorStatusBadge = AgentlessConnectorStatusBadge;