"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyncJobsStats = exports.FetchSyncJobsStatsApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSyncJobsStats = async ({
  isCrawler,
  http
}) => {
  const route = '/internal/content_connectors/stats/sync_jobs';
  const options = isCrawler !== undefined ? {
    query: {
      isCrawler
    }
  } : undefined;
  return await (http === null || http === void 0 ? void 0 : http.get(route, options));
};
exports.fetchSyncJobsStats = fetchSyncJobsStats;
const FetchSyncJobsStatsApiLogic = exports.FetchSyncJobsStatsApiLogic = (0, _create_api_logic.createApiLogic)(['search_connectors_content', 'fetch_sync_jobs_stats_api_logic'], fetchSyncJobsStats);