"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routeValidationConfig = exports.nonEmptyString = exports.acceptedHttpVerb = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const acceptedHttpVerb = exports.acceptedHttpVerb = _configSchema.schema.string({
  validate: method => {
    return ['HEAD', 'GET', 'POST', 'PUT', 'DELETE', 'PATCH'].some(verb => verb.toLowerCase() === method.toLowerCase()) ? undefined : `Method must be one of, case insensitive ['HEAD', 'GET', 'POST', 'PUT', 'DELETE', 'PATCH']. Received '${method}'.`;
  }
});
const nonEmptyString = exports.nonEmptyString = _configSchema.schema.string({
  validate: s => s === '' ? 'Expected non-empty string' : undefined
});
const routeValidationConfig = exports.routeValidationConfig = {
  query: _configSchema.schema.object({
    method: acceptedHttpVerb,
    path: nonEmptyString,
    withProductOrigin: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    host: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  body: _configSchema.schema.stream()
};