"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_PATH_END_MARKER = exports.AcceptEndpointComponent = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _shared_component = require("./shared_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const URL_PATH_END_MARKER = exports.URL_PATH_END_MARKER = '__url_path_end__';
class AcceptEndpointComponent extends _shared_component.SharedComponent {
  constructor(endpoint, parent) {
    super(endpoint.id, parent);
    this.endpoint = endpoint;
  }
  match(token, context, editor) {
    if (token !== URL_PATH_END_MARKER) {
      return null;
    }
    if (this.endpoint.methods && -1 === _lodash.default.indexOf(this.endpoint.methods, context.method)) {
      return null;
    }
    const r = super.match(token, context, editor);
    r.context_values = r.context_values || {};
    r.context_values.endpoint = this.endpoint;
    if (_lodash.default.isNumber(this.endpoint.priority)) {
      r.priority = this.endpoint.priority;
    }
    return r;
  }
}
exports.AcceptEndpointComponent = AcceptEndpointComponent;