"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVulnerabilitiesTrends = exports.getVulnTrendsQuery = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getVulnTrendsQuery = () => ({
  index: _constants.BENCHMARK_SCORE_INDEX_DEFAULT_NS,
  size: 0,
  query: {
    bool: {
      must: [{
        term: {
          policy_template: 'vuln_mgmt'
        }
      }, {
        range: {
          '@timestamp': {
            gte: 'now-30d',
            lte: 'now',
            format: 'strict_date_optional_time'
          }
        }
      }]
    }
  },
  aggs: {
    vuln_severity_per_day: {
      date_histogram: {
        field: '@timestamp',
        calendar_interval: '1d',
        order: {
          _key: 'asc'
        }
      },
      aggs: {
        last_doc: {
          top_hits: {
            size: 1,
            sort: [{
              '@timestamp': {
                order: 'desc'
              }
            }]
          }
        }
      }
    }
  }
});
exports.getVulnTrendsQuery = getVulnTrendsQuery;
const getVulnerabilitiesTrends = async esClient => {
  var _vulnTrendsQueryResul, _vulnTrendsQueryResul2;
  const vulnTrendsQueryResult = await esClient.search(getVulnTrendsQuery());
  if (!vulnTrendsQueryResult.hits.hits) {
    throw new Error('Missing trend results from score index');
  }
  const vulnStatsTrendDocs = (_vulnTrendsQueryResul = vulnTrendsQueryResult.aggregations) === null || _vulnTrendsQueryResul === void 0 ? void 0 : (_vulnTrendsQueryResul2 = _vulnTrendsQueryResul.vuln_severity_per_day.buckets) === null || _vulnTrendsQueryResul2 === void 0 ? void 0 : _vulnTrendsQueryResul2.map(bucket => bucket.last_doc.hits.hits[0]._source);
  return vulnStatsTrendDocs || [];
};
exports.getVulnerabilitiesTrends = getVulnerabilitiesTrends;