"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.latestVulnerabilitiesTransform = exports.DEPRECATED_VULN_TRANSFORM_VERSIONS = void 0;
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CURRENT_VULN_TRANSFORM_VERSION = 'cloud_security_posture.vulnerabilities_latest-default-8.15.0';
const DEPRECATED_VULN_TRANSFORM_VERSIONS = exports.DEPRECATED_VULN_TRANSFORM_VERSIONS = ['cloud_security_posture.vulnerabilities_latest-default-8.8.0'];
const latestVulnerabilitiesTransform = exports.latestVulnerabilitiesTransform = {
  transform_id: CURRENT_VULN_TRANSFORM_VERSION,
  description: 'Defines vulnerabilities transformation to view only the latest vulnerability per resource',
  source: {
    index: _constants.VULNERABILITIES_INDEX_PATTERN
  },
  dest: {
    index: _cloudSecurityPostureCommon.CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN
  },
  frequency: '5m',
  sync: {
    time: {
      field: 'event.ingested',
      delay: '60s'
    }
  },
  retention_policy: {
    time: {
      field: '@timestamp',
      max_age: _cloudSecurityPostureCommon.LATEST_VULNERABILITIES_RETENTION_POLICY
    }
  },
  latest: {
    sort: '@timestamp',
    unique_key: ['vulnerability.id', 'resource.id', 'package.name', 'package.version']
  },
  settings: {
    unattended: true
  },
  _meta: {
    package: {
      name: _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME
    },
    managed_by: 'cloud_security_posture',
    managed: true
  }
};