"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CLOUD_DATA_SAVED_OBJECT_TYPE = void 0;
exports.getOnboardingToken = getOnboardingToken;
exports.setupSavedObjects = setupSavedObjects;
var _constants = require("../routes/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD_DATA_SAVED_OBJECT_TYPE = exports.CLOUD_DATA_SAVED_OBJECT_TYPE = 'cloud';
function setupSavedObjects(savedObjects, logger) {
  savedObjects.registerType({
    name: CLOUD_DATA_SAVED_OBJECT_TYPE,
    hidden: true,
    hiddenFromHttpApis: true,
    namespaceType: 'agnostic',
    mappings: {
      dynamic: false,
      properties: {}
    },
    management: {
      importableAndExportable: false
    },
    modelVersions: {}
  });
}

// needs a client with permissions to read the cloud data saved object
async function getOnboardingToken(savedObjectsClient) {
  var _cloudDataSo, _cloudDataSo$attribut;
  let cloudDataSo = null;
  try {
    cloudDataSo = await savedObjectsClient.get(CLOUD_DATA_SAVED_OBJECT_TYPE, _constants.CLOUD_DATA_SAVED_OBJECT_ID);
  } catch (error) {
    cloudDataSo = null;
  }
  return ((_cloudDataSo = cloudDataSo) === null || _cloudDataSo === void 0 ? void 0 : (_cloudDataSo$attribut = _cloudDataSo.attributes.onboardingData) === null || _cloudDataSo$attribut === void 0 ? void 0 : _cloudDataSo$attribut.token) || null;
}