"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maybeAddCloudLinks = maybeAddCloudLinks;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _user_menu_links = require("./user_menu_links");
var _help_menu_links = require("./help_menu_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function maybeAddCloudLinks({
  core,
  security,
  cloud,
  isServerless
}) {
  const userObservable = (0, _rxjs.defer)(() => security.authc.getCurrentUser()).pipe(
  // Check if user is a cloud user.
  (0, _rxjs.map)(user => user.elastic_cloud_user),
  // If user is not defined due to an unexpected error, then fail *open*.
  (0, _rxjs.catchError)(() => (0, _rxjs.of)(true)), (0, _rxjs.filter)(isElasticCloudUser => isElasticCloudUser === true), (0, _rxjs.switchMap)(() => {
    if (cloud.deploymentUrl) {
      core.chrome.setCustomNavLink({
        title: _i18n.i18n.translate('xpack.cloudLinks.deploymentLinkLabel', {
          defaultMessage: 'Manage this deployment'
        }),
        euiIconType: 'logoCloud',
        href: cloud.deploymentUrl
      });
    }

    // Convert the promise to an observable and handle it properly
    return (0, _rxjs.from)((0, _user_menu_links.createUserMenuLinks)({
      core,
      cloud,
      security,
      isServerless
    })).pipe((0, _rxjs.map)(userMenuLinks => {
      security.navControlService.addUserMenuLinks(userMenuLinks);
    }));
  }));
  const helpObservable = core.chrome.getHelpSupportUrl$();
  if (cloud.isCloudEnabled) {
    (0, _rxjs.combineLatest)({
      user: userObservable,
      helpSupportUrl: helpObservable
    }).subscribe(({
      helpSupportUrl
    }) => {
      const helpMenuLinks = (0, _help_menu_links.createHelpMenuLinks)({
        docLinks: core.docLinks,
        helpSupportUrl,
        isServerless
      });
      core.chrome.setHelpMenuLinks(helpMenuLinks);
    });
  }
}