"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppearance = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _userProfileComponents = require("@kbn/user-profile-components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAppearance = ({
  uiSettingsClient,
  defaultColorMode,
  defaultContrastMode
}) => {
  // If a value is set in kibana.yml (uiSettings.overrides.theme:darkMode)
  // we don't allow the user to change the theme color.
  const valueSetInKibanaConfig = uiSettingsClient.isOverridden('theme:darkMode');
  const {
    userProfileData,
    isLoading,
    update,
    userProfileLoaded
  } = (0, _userProfileComponents.useUpdateUserProfile)({
    notificationSuccess: {
      title: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearance.successNotificationTitle', {
        defaultMessage: 'Appearance settings updated'
      }),
      pageReloadText: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearance.successNotificationText', {
        defaultMessage: 'Reload the page to see the changes'
      })
    },
    pageReloadChecker: (prev, next) => {
      var _prev$userSettings, _next$userSettings, _prev$userSettings2, _next$userSettings2;
      const hasChangedDarkMode = (prev === null || prev === void 0 ? void 0 : (_prev$userSettings = prev.userSettings) === null || _prev$userSettings === void 0 ? void 0 : _prev$userSettings.darkMode) !== ((_next$userSettings = next.userSettings) === null || _next$userSettings === void 0 ? void 0 : _next$userSettings.darkMode);
      const hasChangedContrastMode = (prev === null || prev === void 0 ? void 0 : (_prev$userSettings2 = prev.userSettings) === null || _prev$userSettings2 === void 0 ? void 0 : _prev$userSettings2.contrastMode) !== ((_next$userSettings2 = next.userSettings) === null || _next$userSettings2 === void 0 ? void 0 : _next$userSettings2.contrastMode);
      return hasChangedDarkMode || hasChangedContrastMode;
    }
  });
  const {
    userSettings: {
      darkMode: colorModeUserProfile = defaultColorMode,
      contrastMode: contrastModeUserProfile = defaultContrastMode
    } = {}
  } = userProfileData !== null && userProfileData !== void 0 ? userProfileData : {
    userSettings: {}
  };
  const [colorMode, setColorMode] = (0, _react.useState)(colorModeUserProfile);
  const [initialColorModeValue, setInitialColorModeValue] = (0, _react.useState)(colorModeUserProfile);
  const [contrastMode, setContrastMode] = (0, _react.useState)(contrastModeUserProfile);
  const [initialContrastModeValue, setInitialContrastModeValue] = (0, _react.useState)(contrastModeUserProfile);
  const onChange = (0, _react.useCallback)(({
    colorMode: updatedColorMode,
    contrastMode: updatedContrastMode
  }, persist) => {
    if (isLoading) {
      return;
    }

    // optimistic update
    if (updatedColorMode) {
      setColorMode(updatedColorMode);
    }
    if (updatedContrastMode) {
      setContrastMode(updatedContrastMode);
    }
    if (!persist) {
      return;
    }
    return update({
      userSettings: {
        darkMode: updatedColorMode,
        contrastMode: updatedContrastMode
      }
    });
  }, [isLoading, update]);
  (0, _react.useEffect)(() => {
    setColorMode(colorModeUserProfile);
    setContrastMode(contrastModeUserProfile);
  }, [colorModeUserProfile, contrastModeUserProfile]);
  (0, _react.useEffect)(() => {
    if (userProfileLoaded) {
      var _userProfileData$user;
      const {
        darkMode: storedValueDarkMode,
        contrastMode: storedValueContrastMode
      } = (_userProfileData$user = userProfileData === null || userProfileData === void 0 ? void 0 : userProfileData.userSettings) !== null && _userProfileData$user !== void 0 ? _userProfileData$user : {};
      if (storedValueDarkMode) {
        setInitialColorModeValue(storedValueDarkMode);
      }
      if (storedValueContrastMode) {
        setInitialContrastModeValue(storedValueContrastMode);
      }
    }
  }, [userProfileData, userProfileLoaded]);
  return {
    setColorMode,
    colorMode,
    initialColorModeValue,
    setContrastMode,
    contrastMode,
    initialContrastModeValue,
    isVisible: valueSetInKibanaConfig ? false : Boolean(userProfileData),
    isLoading,
    onChange
  };
};
exports.useAppearance = useAppearance;