"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCasesAnalyticsIndex = void 0;
var _analytics_index = require("../analytics_index");
var _constants = require("./constants");
var _mappings = require("./mappings");
var _painless_scripts = require("./painless_scripts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCasesAnalyticsIndex = ({
  esClient,
  logger,
  isServerless,
  taskManager,
  spaceId,
  owner
}) => new _analytics_index.AnalyticsIndex({
  logger,
  esClient,
  isServerless,
  taskManager,
  indexName: (0, _constants.getCasesDestinationIndexName)(spaceId, owner),
  indexAlias: (0, _constants.getCasesDestinationIndexAlias)(spaceId, owner),
  indexVersion: _constants.CAI_CASES_INDEX_VERSION,
  mappings: _mappings.CAI_CASES_INDEX_MAPPINGS,
  painlessScriptId: _painless_scripts.CAI_CASES_INDEX_SCRIPT_ID,
  painlessScript: _painless_scripts.CAI_CASES_INDEX_SCRIPT,
  taskId: (0, _constants.getCAICasesBackfillTaskId)(spaceId, owner),
  sourceIndex: _constants.CAI_CASES_SOURCE_INDEX,
  sourceQuery: (0, _constants.getCasesSourceQuery)(spaceId, owner)
});
exports.createCasesAnalyticsIndex = createCasesAnalyticsIndex;