"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = exports.caseFormFieldsSchemaWithOptionalLabel = void 0;
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _constants = require("../../../common/constants");
var _optional_field_label = require("../optional_field_label");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../case_form_fields/utils");
var _schema = require("../case_form_fields/schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  maxLengthField
} = _helpers.fieldValidators;
const nonOptionalFields = ['connectorId', 'fields', 'severity', 'customFields'];

// add optional label to all case form fields
const caseFormFieldsSchemaWithOptionalLabel = exports.caseFormFieldsSchemaWithOptionalLabel = Object.fromEntries(Object.entries(_schema.schema).map(([key, value]) => {
  if (typeof value === 'object' && !nonOptionalFields.includes(key)) {
    const updatedValue = {
      ...value,
      labelAppend: _optional_field_label.OptionalFieldLabel
    };
    return [key, updatedValue];
  }
  return [key, value];
}));
const schema = exports.schema = {
  key: {
    validations: [{
      validator: emptyField(i18n.REQUIRED_FIELD('key'))
    }]
  },
  name: {
    label: i18n.TEMPLATE_NAME,
    validations: [{
      validator: emptyField(i18n.REQUIRED_FIELD(i18n.TEMPLATE_NAME))
    }, {
      validator: maxLengthField({
        length: _constants.MAX_TEMPLATE_NAME_LENGTH,
        message: i18n.MAX_LENGTH_ERROR('template name', _constants.MAX_TEMPLATE_NAME_LENGTH)
      })
    }]
  },
  templateDescription: {
    label: i18n.DESCRIPTION,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: maxLengthField({
        length: _constants.MAX_TEMPLATE_DESCRIPTION_LENGTH,
        message: i18n.MAX_LENGTH_ERROR('template description', _constants.MAX_TEMPLATE_DESCRIPTION_LENGTH)
      })
    }]
  },
  templateTags: {
    label: i18n.TAGS,
    helpText: i18n.TEMPLATE_TAGS_HELP,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    validations: [{
      validator: ({
        value
      }) => (0, _utils.validateEmptyTags)({
        value,
        message: i18n.TAGS_EMPTY_ERROR
      }),
      type: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM,
      isBlocking: false
    }, {
      validator: ({
        value
      }) => (0, _utils.validateMaxLength)({
        value,
        message: i18n.MAX_LENGTH_ERROR('tag', _constants.MAX_TEMPLATE_TAG_LENGTH),
        limit: _constants.MAX_TEMPLATE_TAG_LENGTH
      }),
      type: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM,
      isBlocking: false
    }, {
      validator: ({
        value
      }) => (0, _utils.validateMaxTagsLength)({
        value,
        message: i18n.MAX_TAGS_ERROR(_constants.MAX_TAGS_PER_TEMPLATE),
        limit: _constants.MAX_TAGS_PER_TEMPLATE
      })
    }]
  },
  ...caseFormFieldsSchemaWithOptionalLabel
};