"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUploadComplete = useUploadComplete;
var _react = require("react");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUploadComplete(state, replacePlaceholder, dispatch) {
  (0, _react.useEffect)(() => {
    const {
      phase
    } = state;
    if (phase !== _types.UploadPhase.FINISHED) return;
    const {
      file,
      placeholder
    } = state;
    replacePlaceholder(file, placeholder);
    dispatch({
      type: _types.ActionType.RESET
    });
  }, [state, replacePlaceholder, dispatch]);
}