"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIssues = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _use_is_user_typing = require("../../../common/use_is_user_typing");
var _kibana = require("../../../common/lib/kibana");
var _use_get_issues = require("./use_get_issues");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_issue = require("./use_get_issue");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/jira/search_issues.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchIssuesFieldComponent = ({
  field,
  options,
  isLoading,
  onSearchComboChange
}) => {
  const {
    value: parent
  } = field;
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const selectedOptions = [parent].map(currentParent => {
    const selectedParent = options.find(issue => issue.value === currentParent);
    if (selectedParent) {
      return selectedParent;
    }
    return null;
  }).filter(value => value != null);
  const onChangeComboBox = changedOptions => {
    var _changedOptions$0$val;
    field.setValue(changedOptions.length ? (_changedOptions$0$val = changedOptions[0].value) !== null && _changedOptions$0$val !== void 0 ? _changedOptions$0$val : '' : '');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "indexConnectorSelectSearchBox",
    fullWidth: true,
    label: i18n.PARENT_ISSUE,
    isInvalid: isInvalid,
    error: errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: true,
    async: true,
    placeholder: i18n.SEARCH_ISSUES_PLACEHOLDER,
    "aria-label": i18n.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL,
    isLoading: isLoading,
    isInvalid: isInvalid,
    noSuggestions: !options.length,
    options: options,
    "data-test-subj": "search-parent-issues",
    "data-testid": "search-parent-issues",
    selectedOptions: selectedOptions,
    onChange: onChangeComboBox,
    onSearchChange: onSearchComboChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }));
};
SearchIssuesFieldComponent.displayName = 'SearchIssuesField';
const SearchIssuesComponent = ({
  actionConnector
}) => {
  var _fields$parent, _issuesData$data;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const [{
    fields
  }] = (0, _hook_form_lib.useFormData)({
    watch: ['fields.parent']
  });
  const [query, setQuery] = (0, _react.useState)(null);
  const {
    isUserTyping,
    onContentChange,
    onDebounce
  } = (0, _use_is_user_typing.useIsUserTyping)();
  const {
    isFetching: isLoadingIssues,
    data: issuesData
  } = (0, _use_get_issues.useGetIssues)({
    http,
    actionConnector,
    query,
    onDebounce
  });
  const {
    isFetching: isLoadingIssue,
    data: issueData
  } = (0, _use_get_issue.useGetIssue)({
    http,
    actionConnector,
    id: (_fields$parent = fields === null || fields === void 0 ? void 0 : fields.parent) !== null && _fields$parent !== void 0 ? _fields$parent : ''
  });
  const issues = (_issuesData$data = issuesData === null || issuesData === void 0 ? void 0 : issuesData.data) !== null && _issuesData$data !== void 0 ? _issuesData$data : [];
  const issue = issueData !== null && issueData !== void 0 && issueData.data ? [issueData.data] : [];
  const onSearchComboChange = value => {
    if (!(0, _lodash.isEmpty)(value)) {
      setQuery(value);
    }
    onContentChange(value);
  };
  const isLoading = isUserTyping || isLoadingIssues || isLoadingIssue;
  const options = [...issues, ...issue].map(_issue => ({
    label: _issue.title,
    value: _issue.key
  }));
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.parent",
    component: SearchIssuesFieldComponent,
    componentProps: {
      isLoading,
      onSearchComboChange,
      options
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  });
};
SearchIssuesComponent.displayName = 'SearchIssues';
const SearchIssues = exports.SearchIssues = /*#__PURE__*/(0, _react.memo)(SearchIssuesComponent);