"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssignUsers = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_assignees = require("../../../containers/user_profiles/use_assignees");
var i18n = _interopRequireWildcard(require("../translations"));
var _sidebar_title = require("./sidebar_title");
var _removable_user = require("../../user_profiles/removable_user");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _suggest_users_popover = require("./suggest_users_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/assign_users.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AssigneesList = ({
  assignees,
  currentUserProfile,
  permissions,
  assignSelf,
  togglePopOver,
  onAssigneeRemoved
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, assignees.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 15
    }
  }, i18n.NO_ASSIGNEES, permissions.update && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "case-view-assign-users-link",
    onClick: togglePopOver,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 21
    }
  }, i18n.ASSIGN_A_USER)), currentUserProfile && permissions.update && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 21
    }
  }, i18n.SPACED_OR), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "case-view-assign-yourself-link",
    onClick: assignSelf,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 21
    }
  }, i18n.ASSIGN_YOURSELF)))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, assignees.map(assignee => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: assignee.uid,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_removable_user.RemovableUser, {
    assignee: assignee,
    onRemoveAssignee: onAssigneeRemoved,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  })))));
};
AssigneesList.displayName = 'AssigneesList';
const AssignUsersComponent = ({
  caseAssignees,
  userProfiles,
  currentUserProfile,
  onAssigneesChanged,
  isLoading
}) => {
  const {
    assigneesWithProfiles,
    assigneesWithoutProfiles,
    allAssignees
  } = (0, _use_assignees.useAssignees)({
    caseAssignees,
    userProfiles
  });
  const [selectedAssignees, setSelectedAssignees] = (0, _react.useState)();
  const [needToUpdateAssignees, setNeedToUpdateAssignees] = (0, _react.useState)(false);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(value => !value);
    setNeedToUpdateAssignees(true);
  }, []);
  const onClosePopover = (0, _react.useCallback)(() => {
    // Order matters here because needToUpdateAssignees will likely be true already
    // from the togglePopover call when opening the popover, so if we set the popover to false
    // first, we'll get a rerender and then get another after we set needToUpdateAssignees to true again
    setNeedToUpdateAssignees(true);
    setIsPopoverOpen(false);
  }, []);
  const onAssigneeRemoved = (0, _react.useCallback)(removedAssigneeUID => {
    const remainingAssignees = allAssignees.filter(assignee => assignee.uid !== removedAssigneeUID);
    setSelectedAssignees(remainingAssignees);
    setNeedToUpdateAssignees(true);
  }, [allAssignees]);
  const onUsersChange = (0, _react.useCallback)(users => {
    // if users are selected then also include the users without profiles
    if (users.length > 0) {
      setSelectedAssignees([...users, ...assigneesWithoutProfiles]);
    } else {
      // all users were deselected so lets remove the users without profiles as well
      setSelectedAssignees([]);
    }
  }, [assigneesWithoutProfiles]);
  const assignSelf = (0, _react.useCallback)(() => {
    if (!currentUserProfile) {
      return;
    }
    const newAssignees = [currentUserProfile, ...allAssignees];
    setSelectedAssignees(newAssignees);
    setNeedToUpdateAssignees(true);
  }, [currentUserProfile, allAssignees]);
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  (0, _react.useEffect)(() => {
    // selectedAssignees will be undefined on initial render or a rerender occurs, so we only want to update the assignees
    // after the users have been changed in some manner not when it is an initial value
    if (isPopoverOpen === false && needToUpdateAssignees && selectedAssignees) {
      setNeedToUpdateAssignees(false);
      onAssigneesChanged(selectedAssignees);
    }
  }, [isPopoverOpen, needToUpdateAssignees, onAssigneesChanged, selectedAssignees]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "case-view-assignees",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sidebar_title.SidebarTitle, {
    title: i18n.ASSIGNEES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  })), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "case-view-assignees-button-loading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 23
    }
  }), !isLoading && permissions.assign && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-view-assignees-edit",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_suggest_users_popover.SuggestUsersPopover, {
    assignedUsersWithProfiles: assigneesWithProfiles,
    currentUserProfile: currentUserProfile,
    isLoading: isLoading,
    isPopoverOpen: isPopoverOpen,
    onUsersChange: onUsersChange,
    onClosePopover: onClosePopover,
    togglePopover: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AssigneesList, {
    assignees: allAssignees,
    currentUserProfile: currentUserProfile,
    permissions: permissions,
    assignSelf: assignSelf,
    togglePopOver: togglePopover,
    onAssigneeRemoved: onAssigneeRemoved,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }));
};
AssignUsersComponent.displayName = 'AssignUsers';
const AssignUsers = exports.AssignUsers = /*#__PURE__*/_react.default.memo(AssignUsersComponent);