"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttachEventsEBT = void 0;
var _react = require("react");
var _common = require("../../common");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var _files = require("../files");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Events Based Tracking for Case Event attachments being created
 */
const useAttachEventsEBT = () => {
  const {
    analytics
  } = (0, _kibana.useKibana)().services;
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  return (0, _react.useCallback)((attachmentSource, attachments) => {
    // NOTE: we just want to track case event attachments
    if (!attachments.some(attachment => attachment.type === _common.AttachmentType.event)) {
      return;
    }
    analytics.reportEvent(_constants.CASE_ATTACH_EVENTS_EVENT_TYPE, {
      owner: owner[0] && (0, _files.isRegisteredOwner)(owner[0]) ? owner[0] : 'unknown',
      attachment_source: attachmentSource
    });
  }, [analytics, owner]);
};
exports.useAttachEventsEBT = useAttachEventsEBT;