"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseStatusRt = exports.CaseSeverityRt = exports.CaseSeverity = exports.CaseSettingsRt = exports.CaseRt = exports.CaseBaseOptionalFieldsRt = exports.CaseAttributesRt = exports.AttachmentTotalsRt = void 0;
Object.defineProperty(exports, "CaseStatuses", {
  enumerable: true,
  get: function () {
    return _types.CaseStatuses;
  }
});
exports.caseStatuses = exports.SimilarityRt = exports.SimilarCaseRt = exports.RelatedCaseRt = exports.CasesRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _types = require("@kbn/cases-components/src/status/types");
var _v = require("../external_service/v1");
var _v2 = require("../user/v1");
var _v3 = require("../connector/v1");
var _v4 = require("../attachment/v1");
var _v5 = require("../custom_field/v1");
var _v6 = require("../observable/v1");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Status
 */
const CaseStatusRt = exports.CaseStatusRt = rt.union([rt.literal(_types.CaseStatuses.open), rt.literal(_types.CaseStatuses['in-progress']), rt.literal(_types.CaseStatuses.closed)]);
const caseStatuses = exports.caseStatuses = Object.values(_types.CaseStatuses);

/**
 * Severity
 */
let CaseSeverity = exports.CaseSeverity = /*#__PURE__*/function (CaseSeverity) {
  CaseSeverity["LOW"] = "low";
  CaseSeverity["MEDIUM"] = "medium";
  CaseSeverity["HIGH"] = "high";
  CaseSeverity["CRITICAL"] = "critical";
  return CaseSeverity;
}({});
const CaseSeverityRt = exports.CaseSeverityRt = rt.union([rt.literal(CaseSeverity.LOW), rt.literal(CaseSeverity.MEDIUM), rt.literal(CaseSeverity.HIGH), rt.literal(CaseSeverity.CRITICAL)]);

/**
 * Case
 */

const CaseSettingsRt = exports.CaseSettingsRt = rt.intersection([rt.strict({
  syncAlerts: rt.boolean
}), rt.exact(rt.partial({
  extractObservables: rt.boolean
}))]);
const CaseBaseFields = {
  /**
   * The description of the case
   */
  description: rt.string,
  /**
   * The identifying strings for filter a case
   */
  tags: rt.array(rt.string),
  /**
   * The title of a case
   */
  title: rt.string,
  /**
   * The external system that the case can be synced with
   */
  connector: _v3.CaseConnectorRt,
  /**
   * The severity of the case
   */
  severity: CaseSeverityRt,
  /**
   * The users assigned to this case
   */
  assignees: _v2.CaseAssigneesRt,
  /**
   * The category of the case.
   */
  category: rt.union([rt.string, rt.null]),
  /**
   * An array containing the possible,
   * user-configured custom fields.
   */
  customFields: _v5.CaseCustomFieldsRt,
  /**
   * The alert sync settings
   */
  settings: CaseSettingsRt,
  /**
   * Observables
   */
  observables: rt.array(_v6.CaseObservableRt)
};
const CaseBaseOptionalFieldsRt = exports.CaseBaseOptionalFieldsRt = rt.exact(rt.partial({
  ...CaseBaseFields
}));
const CaseBasicRt = rt.strict({
  /**
   * The current status of the case (open, closed, in-progress)
   */
  status: CaseStatusRt,
  /**
   * The plugin owner of the case
   */
  owner: rt.string,
  ...CaseBaseFields
});
const CaseAttributesRt = exports.CaseAttributesRt = rt.intersection([CaseBasicRt, rt.strict({
  duration: rt.union([rt.number, rt.null]),
  closed_at: rt.union([rt.string, rt.null]),
  closed_by: rt.union([_v2.UserRt, rt.null]),
  created_at: rt.string,
  created_by: _v2.UserRt,
  external_service: rt.union([_v.ExternalServiceRt, rt.null]),
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_v2.UserRt, rt.null]),
  total_observables: rt.union([rt.number, rt.null])
}), rt.exact(rt.partial({
  incremental_id: rt.union([rt.number, rt.null]),
  in_progress_at: rt.union([rt.string, rt.null]),
  time_to_acknowledge: rt.union([rt.number, rt.null]),
  time_to_investigate: rt.union([rt.number, rt.null]),
  time_to_resolve: rt.union([rt.number, rt.null])
}))]);
const CaseRt = exports.CaseRt = rt.intersection([CaseAttributesRt, rt.strict({
  id: rt.string,
  totalComment: rt.number,
  totalAlerts: rt.number,
  totalEvents: rt.union([rt.number, rt.undefined]),
  version: rt.string
}), rt.exact(rt.partial({
  comments: rt.array(_v4.AttachmentRt)
}))]);
const CasesRt = exports.CasesRt = rt.array(CaseRt);
const AttachmentTotalsRt = exports.AttachmentTotalsRt = rt.strict({
  alerts: rt.number,
  events: rt.number,
  userComments: rt.number
});
const RelatedCaseRt = exports.RelatedCaseRt = rt.strict({
  id: rt.string,
  title: rt.string,
  description: rt.string,
  status: CaseStatusRt,
  createdAt: rt.string,
  totals: AttachmentTotalsRt
});
const SimilarityRt = exports.SimilarityRt = rt.strict({
  typeKey: rt.string,
  typeLabel: rt.string,
  value: rt.string
});
const SimilarCaseRt = exports.SimilarCaseRt = rt.intersection([CaseRt, rt.strict({
  similarities: rt.strict({
    observables: rt.array(SimilarityRt)
  })
})]);