"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OBSERVABLE_TYPE_URL = exports.OBSERVABLE_TYPE_IPV6 = exports.OBSERVABLE_TYPE_IPV4 = exports.OBSERVABLE_TYPE_HOSTNAME = exports.OBSERVABLE_TYPE_FILE_PATH = exports.OBSERVABLE_TYPE_FILE_HASH = exports.OBSERVABLE_TYPE_EMAIL = exports.OBSERVABLE_TYPE_DOMAIN = exports.OBSERVABLE_TYPE_AGENT_ID = exports.OBSERVABLE_TYPES_BUILTIN_KEYS = exports.OBSERVABLE_TYPES_BUILTIN = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVABLE_TYPE_IPV4 = exports.OBSERVABLE_TYPE_IPV4 = {
  label: 'IPv4',
  key: 'observable-type-ipv4'
};
const OBSERVABLE_TYPE_IPV6 = exports.OBSERVABLE_TYPE_IPV6 = {
  label: 'IPv6',
  key: 'observable-type-ipv6'
};
const OBSERVABLE_TYPE_URL = exports.OBSERVABLE_TYPE_URL = {
  label: 'URL',
  key: 'observable-type-url'
};
const OBSERVABLE_TYPE_HOSTNAME = exports.OBSERVABLE_TYPE_HOSTNAME = {
  label: 'Host name',
  key: 'observable-type-hostname'
};
const OBSERVABLE_TYPE_FILE_HASH = exports.OBSERVABLE_TYPE_FILE_HASH = {
  label: 'File hash',
  key: 'observable-type-file-hash'
};
const OBSERVABLE_TYPE_FILE_PATH = exports.OBSERVABLE_TYPE_FILE_PATH = {
  label: 'File path',
  key: 'observable-type-file-path'
};
const OBSERVABLE_TYPE_EMAIL = exports.OBSERVABLE_TYPE_EMAIL = {
  label: 'Email',
  key: 'observable-type-email'
};
const OBSERVABLE_TYPE_DOMAIN = exports.OBSERVABLE_TYPE_DOMAIN = {
  label: 'Domain',
  key: 'observable-type-domain'
};
const OBSERVABLE_TYPE_AGENT_ID = exports.OBSERVABLE_TYPE_AGENT_ID = {
  label: 'Agent id',
  key: 'observable-type-agent-id'
};

/**
 * Exporting an array of built-in observable types for use in the application
 */
const OBSERVABLE_TYPES_BUILTIN = exports.OBSERVABLE_TYPES_BUILTIN = [OBSERVABLE_TYPE_AGENT_ID, OBSERVABLE_TYPE_IPV4, OBSERVABLE_TYPE_IPV6, OBSERVABLE_TYPE_URL, OBSERVABLE_TYPE_HOSTNAME, OBSERVABLE_TYPE_FILE_HASH, OBSERVABLE_TYPE_FILE_PATH, OBSERVABLE_TYPE_EMAIL, OBSERVABLE_TYPE_DOMAIN];
const OBSERVABLE_TYPES_BUILTIN_KEYS = exports.OBSERVABLE_TYPES_BUILTIN_KEYS = OBSERVABLE_TYPES_BUILTIN.map(({
  key
}) => key);