"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseStatuses = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * This is being used by Cases in
 * x-pack/platform/plugins/shared/cases/common/types/domain/case/v1.ts.
 * Introducing a breaking change in this enum will
 * force cases to create a version of the domain object
 * which in turn will force cases to create a new version
 * to most of the Cases APIs.
 */
let CaseStatuses = exports.CaseStatuses = /*#__PURE__*/function (CaseStatuses) {
  CaseStatuses["open"] = "open";
  CaseStatuses["in-progress"] = "in-progress";
  CaseStatuses["closed"] = "closed";
  return CaseStatuses;
}({});