"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encode = exports.decode = void 0;
var _lzString = _interopRequireDefault(require("lz-string"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const encode = state => {
  try {
    const stateJSON = JSON.stringify(state);
    return _lzString.default.compress(stateJSON);
  } catch (e) {
    throw new Error(`Could not encode state: ${e.message}`);
  }
};
exports.encode = encode;
const decode = payload => {
  try {
    var _lzString$decompress;
    const stateJSON = (_lzString$decompress = _lzString.default.decompress(payload)) !== null && _lzString$decompress !== void 0 ? _lzString$decompress : 'null';
    return JSON.parse(stateJSON);
  } catch (e) {
    return null;
  }
};
exports.decode = decode;