"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkpadPersist = void 0;
var _react = require("react");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _reactRedux = require("react-redux");
var _workpad = require("../../../state/selectors/workpad");
var _app = require("../../../state/selectors/app");
var _assets = require("../../../lib/assets");
var _canvas_workpad_service = require("../../../services/canvas_workpad_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWorkpadPersist = () => {
  // Watch for workpad state and then persist those changes
  const [workpad, canWrite] = (0, _reactRedux.useSelector)(state => [(0, _workpad.getWorkpad)(state), (0, _app.canUserWrite)(state)]);
  const previousWorkpad = (0, _usePrevious.default)(workpad);
  const workpadChanged = previousWorkpad && workpad !== previousWorkpad;
  (0, _react.useEffect)(() => {
    if (canWrite) {
      if (workpadChanged) {
        (0, _canvas_workpad_service.getCanvasWorkpadService)().updateWorkpad(workpad.id, workpad).catch(err => {
          (0, _assets.notifyError)(err);
        });
      }
    }
  }, [workpad, workpadChanged, canWrite]);
};
exports.useWorkpadPersist = useWorkpadPersist;