"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _find_expression_type = require("../../lib/find_expression_type");
var _assets = require("../../state/actions/assets");
var _elements = require("../../state/actions/elements");
var _workpad = require("../../state/selectors/workpad");
var _assets2 = require("../../state/selectors/assets");
var _find_existing_asset = require("../../lib/find_existing_asset");
var _function_form = require("./function_form");
var _assets3 = require("../../lib/assets");
var _canvas_workpad_service = require("../../services/canvas_workpad_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/function_form/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error unconverted action function
// @ts-expect-error unconverted lib
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FunctionForm = props => {
  const {
    expressionIndex,
    ...restProps
  } = props;
  const {
    nextArgType,
    path,
    parentPath,
    argType
  } = restProps;
  const dispatch = (0, _reactRedux.useDispatch)();
  const context = (0, _reactRedux.useSelector)(state => (0, _workpad.getContextForIndex)(state, parentPath, expressionIndex), _reactFastCompare.default);
  const element = (0, _reactRedux.useSelector)(state => (0, _workpad.getSelectedElement)(state), _reactFastCompare.default);
  const pageId = (0, _reactRedux.useSelector)(state => (0, _workpad.getSelectedPage)(state), _reactRedux.shallowEqual);
  const assets = (0, _reactRedux.useSelector)(state => (0, _assets2.getAssets)(state), _reactRedux.shallowEqual);
  const filterGroups = (0, _reactRedux.useSelector)(state => (0, _workpad.getGlobalFilterGroups)(state), _reactRedux.shallowEqual);
  const workpad = (0, _reactRedux.useSelector)(state => (0, _workpad.getFullWorkpadPersisted)(state));
  const addArgument = (0, _react.useCallback)((argName, argValue) => () => {
    dispatch((0, _elements.addArgumentValue)({
      elementId: element === null || element === void 0 ? void 0 : element.id,
      pageId,
      argName,
      value: argValue,
      path
    }));
  }, [dispatch, element === null || element === void 0 ? void 0 : element.id, pageId, path]);
  const updateContext = (0, _react.useCallback)(() => {
    return dispatch((0, _elements.fetchContext)(expressionIndex, element, false, parentPath));
  }, [dispatch, element, expressionIndex, parentPath]);
  const setArgument = (0, _react.useCallback)((argName, valueIndex) => value => {
    dispatch((0, _elements.setArgument)({
      elementId: element === null || element === void 0 ? void 0 : element.id,
      pageId,
      argName,
      value,
      valueIndex,
      path
    }));
  }, [dispatch, element === null || element === void 0 ? void 0 : element.id, pageId, path]);
  const deleteArgument = (0, _react.useCallback)((argName, argIndex) => () => {
    dispatch((0, _elements.deleteArgumentAtIndex)({
      element,
      pageId,
      argName,
      argIndex,
      path
    }));
  }, [dispatch, element, pageId, path]);
  const deleteParentArgument = (0, _react.useCallback)(() => {
    dispatch((0, _elements.deleteArgumentAtIndex)({
      element,
      pageId,
      path: parentPath
    }));
  }, [dispatch, element, pageId, parentPath]);
  const onAssetAddDispatch = (0, _react.useCallback)((type, content) => {
    // make the ID here and pass it into the action
    const asset = (0, _assets3.createAsset)(type, content);
    return (0, _canvas_workpad_service.getCanvasWorkpadService)().updateAssets(workpad.id, {
      ...workpad.assets,
      [asset.id]: asset
    }).then(res => {
      dispatch((0, _assets.setAsset)(asset));
      // then return the id, so the caller knows the id that will be created
      return asset.id;
    }).catch(error => (0, _assets3.notifyError)(error));
  }, [dispatch, workpad.assets, workpad.id]);
  const onAssetAdd = (0, _react.useCallback)((type, content) => {
    const existingId = (0, _find_existing_asset.findExistingAsset)(type, content, assets);
    if (existingId) {
      return existingId;
    }
    return onAssetAddDispatch(type, content);
  }, [assets, onAssetAddDispatch]);
  return /*#__PURE__*/_react.default.createElement(_function_form.FunctionForm, (0, _extends2.default)({}, restProps, {
    id: path,
    context: context,
    filterGroups: filterGroups,
    expressionType: (0, _find_expression_type.findExpressionType)(argType),
    nextExpressionType: nextArgType ? (0, _find_expression_type.findExpressionType)(nextArgType) : undefined,
    onValueAdd: addArgument,
    updateContext: updateContext,
    onValueChange: setArgument,
    onValueRemove: deleteArgument,
    onContainerRemove: deleteParentArgument,
    onAssetAdd: onAssetAdd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }));
};
exports.FunctionForm = FunctionForm;