"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleKV = handleKV;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
var _constants = require("./constants");
var _processors = require("../../util/processors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Handles the KV processor node in the graph
 * @param state
 * @param model
 * @param client
 * @returns Partial<KVState>
 */
async function handleKV({
  state,
  model,
  client
}) {
  const kvMainGraph = _prompts.KV_MAIN_PROMPT.pipe(model).pipe(new _output_parsers.JsonOutputParser());

  // Pick logSamples if there was no header detected.
  const samples = state.header ? state.kvLogMessages : state.logSamples;
  const kvInput = await kvMainGraph.invoke({
    samples: samples[0],
    ex_answer: JSON.stringify(_constants.KV_EXAMPLE_ANSWER, null, 2)
  });
  const kvProcessor = (0, _processors.createKVProcessor)(kvInput, state);
  return {
    kvProcessor,
    lastExecutedChain: 'handleKV'
  };
}